/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class EdgeCrossingEdgeCheck
extends BaseCheck<String> {
    private static final String INSTRUCTION_FORMAT = "The road with id {0,number,#} has invalid crossings. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.";
    private static final String INVALID_EDGE_FORMAT = "Edge {0,number,#} is crossing invalidly.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The road with id {0,number,#} has invalid crossings. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.", "Edge {0,number,#} is crossing invalidly.");
    private static final long serialVersionUID = 2146863485833228593L;

    private static boolean canCross(PolyLine edgeAsPolyLine, Optional<Long> edgeLayer, PolyLine crossingEdgeAsPolyLine, Optional<Long> crossingEdgeLayer, Location intersection) {
        return edgeAsPolyLine.contains(intersection) && crossingEdgeAsPolyLine.contains(intersection) || edgeLayer.isPresent() && crossingEdgeLayer.isPresent() && !edgeLayer.orElse(0L).equals(crossingEdgeLayer.orElse(0L));
    }

    private static String generateAtlasObjectPairIdentifier(AtlasObject thisObject, AtlasObject thatObject) {
        if (thisObject.getIdentifier() < thatObject.getIdentifier()) {
            return thisObject.getIdentifier() + "-" + thatObject.getIdentifier();
        }
        return thatObject.getIdentifier() + "-" + thisObject.getIdentifier();
    }

    private static boolean isValidCrossingEdge(AtlasObject object) {
        Optional<HighwayTag> highway;
        if (Edge.isMasterEdgeIdentifier(object.getIdentifier()) && !TagPredicates.IS_AREA.test(object) && (highway = HighwayTag.highwayTag(object)).isPresent()) {
            return HighwayTag.isCarNavigableHighway(highway.get()) && !HighwayTag.CROSSING.equals((Object)highway.get());
        }
        return false;
    }

    public EdgeCrossingEdgeCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && EdgeCrossingEdgeCheck.isValidCrossingEdge(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        PolyLine edgeAsPolyLine = edge.asPolyLine();
        Rectangle edgeBounds = edge.bounds();
        Optional<Long> edgeLayer = LayerTag.getTaggedValue(object);
        Atlas atlas = object.getAtlas();
        Iterable<Edge> crossingEdges = atlas.edgesIntersecting(edgeBounds, crossingEdge -> edge.getIdentifier() != crossingEdge.getIdentifier() && EdgeCrossingEdgeCheck.isValidCrossingEdge(crossingEdge) && !this.isFlagged(EdgeCrossingEdgeCheck.generateAtlasObjectPairIdentifier(edge, crossingEdge)));
        LinkedList<Edge> invalidEdges = null;
        for (Edge crossingEdge2 : crossingEdges) {
            PolyLine crossingEdgeAsPolyLine = crossingEdge2.asPolyLine();
            Optional<Long> crossingEdgeLayer = LayerTag.getTaggedValue(crossingEdge2);
            Set<Location> intersections = edgeAsPolyLine.intersections(crossingEdgeAsPolyLine);
            for (Location intersection : intersections) {
                this.markAsFlagged(EdgeCrossingEdgeCheck.generateAtlasObjectPairIdentifier(edge, crossingEdge2));
                if (EdgeCrossingEdgeCheck.canCross(edgeAsPolyLine, edgeLayer, crossingEdgeAsPolyLine, crossingEdgeLayer, intersection)) continue;
                if (invalidEdges == null) {
                    invalidEdges = new LinkedList<Edge>();
                }
                invalidEdges.add(crossingEdge2);
            }
        }
        if (invalidEdges != null) {
            CheckFlag newFlag = new CheckFlag(this.getTaskIdentifier(object));
            newFlag.addObject(object);
            newFlag.addInstruction(this.getLocalizedInstruction(0, object.getOsmIdentifier()));
            invalidEdges.forEach(invalidEdge -> {
                newFlag.addObject((AtlasObject)invalidEdge);
                newFlag.addInstruction(this.getLocalizedInstruction(1, invalidEdge.getOsmIdentifier()));
            });
            return Optional.of(newFlag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

