/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.configuration;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.streaming.resource.http.GetResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.MergedConfiguration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationResolver {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationResolver.class);

    public static Configuration emptyConfiguration() {
        return ConfigurationResolver.inlineConfiguration("{}");
    }

    public static Optional<InputStream> getResourceAsStream(URI uri) {
        byte[] configuration = Optional.ofNullable(uri.getScheme()).map(schema -> {
            switch (schema) {
                case "http": 
                case "https": {
                    GetResource getResource = new GetResource(uri);
                    Optional.ofNullable(uri.getUserInfo()).ifPresent(userInfo -> {
                        String[] userPass = userInfo.split(":");
                        if (userPass.length == 2) {
                            getResource.setAuth(userPass[0], userPass[1]);
                        }
                    });
                    logger.info("Getting remote configuration {}", (Object)uri);
                    byte[] response = getResource.readBytesAndClose();
                    if (getResource.getStatusCode() != 200) {
                        throw new CoreException("Failed to get configuration [{}]", new String(response));
                    }
                    return response;
                }
            }
            logger.info("Loading local configuration {}", (Object)uri);
            return new File(uri.getPath()).readBytesAndClose();
        }).orElseThrow(() -> new CoreException("Unable to read configuration {}", uri));
        return Optional.of(new BufferedInputStream(new ByteArrayInputStream(configuration)));
    }

    public static Optional<InputStream> getResourceAsStream(String resource) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Optional.ofNullable(loader.getResourceAsStream(resource));
    }

    public static Configuration inlineConfiguration(String inline) {
        return new StandardConfiguration(new StringResource(inline));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration loadConfiguration(CommandMap commandMap, Command.Switch<StringList> keyFiles, Command.Switch<String> keyJson) {
        MergedConfiguration configuration;
        ArrayList configurationSources = new ArrayList();
        ConfigurationResolver.getResourceAsStream("application.json").ifPresent(configurationSources::add);
        commandMap.getOption(keyFiles).ifPresent(files -> ((StringList)files).forEach(uri -> ConfigurationResolver.getResourceAsStream(URI.create(uri)).ifPresent(configurationSources::add)));
        commandMap.getOption(keyJson).map(value -> new ByteArrayInputStream(value.toString().getBytes(StandardCharsets.UTF_8))).ifPresent(configurationSources::add);
        List configurationResources = configurationSources.stream().map(InputStreamResource::new).collect(Collectors.toList());
        Throwable thrown = null;
        try {
            configuration = new MergedConfiguration((Resource)Iterables.head(configurationResources), Iterables.tail(configurationResources));
        }
        finally {
            for (InputStream source : configurationSources) {
                try {
                    source.close();
                }
                catch (Throwable throwable) {
                    thrown = throwable;
                }
            }
        }
        if (thrown != null) {
            throw new CoreException("Failed to load configuration", thrown);
        }
        return configuration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Configuration resourceConfiguration(String path, Class context) {
        try (InputStream config = context.getResourceAsStream(path);){
            StandardConfiguration standardConfiguration = new StandardConfiguration(new InputStreamResource(config));
            return standardConfiguration;
        }
        catch (IOException oops) {
            Assert.fail(oops.getMessage());
            return null;
        }
    }

    private ConfigurationResolver() {
    }
}

