/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.base;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.collections.EnhancedCollectors;

public class TaskIdentifier {
    private final String identifier;

    public TaskIdentifier(AtlasObject object) {
        this(Collections.singleton(object));
    }

    public TaskIdentifier(Set<AtlasObject> objects) {
        if (objects == null || objects.isEmpty()) {
            throw new CoreException("items can't be empty");
        }
        TreeSet orderedSet = new TreeSet(objects.stream().map(item -> String.valueOf(item.getIdentifier())).collect(EnhancedCollectors.toUnmodifiableSortedSet()));
        this.identifier = StringUtils.join(orderedSet, "");
    }

    public String toString() {
        return this.identifier;
    }
}

