/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.Check;
import org.openstreetmap.atlas.checks.base.TaskIdentifier;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengeDifficulty;
import org.openstreetmap.atlas.checks.maproulette.serializer.ChallengeDeserializer;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.ManMadeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.OptionalIterable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.filters.AtlasEntityPolygonsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCheck<T>
implements Check,
Serializable {
    public static final String PARAMETER_ACCEPT_PIERS = "accept.piers";
    public static final String PARAMETER_BLACKLIST_COUNTRIES = "countries.blacklist";
    public static final String PARAMETER_CHALLENGE = "challenge";
    public static final String PARAMETER_FLAG = "flags";
    public static final String PARAMETER_WHITELIST_COUNTRIES = "countries.whitelist";
    public static final String PARAMETER_WHITELIST_TAGS = "tags.filter";
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String PARAMETER_LOCALE_KEY = "locale";
    private static final Logger logger = LoggerFactory.getLogger(BaseCheck.class);
    private static final long serialVersionUID = 4427673331949586822L;
    private final boolean acceptPiers;
    private final List<String> blacklistCountries;
    private final Challenge challenge;
    private final List<String> countries;
    private final Map<String, List<String>> flagLanguageMap;
    private final Set<T> flaggedIdentifiers = ConcurrentHashMap.newKeySet();
    private final Locale locale;
    private final String name = this.getClass().getSimpleName();
    private final AtlasEntityPolygonsFilter checkPolygonFilter;
    private final AtlasEntityPolygonsFilter globalPolygonFilter;
    private TaggableFilter tagFilter = null;

    public BaseCheck(Configuration configuration) {
        this.acceptPiers = this.configurationValue(configuration, PARAMETER_ACCEPT_PIERS, false);
        this.countries = Collections.unmodifiableList(this.configurationValue(configuration, PARAMETER_WHITELIST_COUNTRIES, Collections.EMPTY_LIST));
        this.blacklistCountries = Collections.unmodifiableList(this.configurationValue(configuration, PARAMETER_BLACKLIST_COUNTRIES, Collections.EMPTY_LIST));
        this.tagFilter = TaggableFilter.forDefinition(this.configurationValue(configuration, PARAMETER_WHITELIST_TAGS, ""));
        Map challengeMap = this.configurationValue(configuration, PARAMETER_CHALLENGE, Collections.EMPTY_MAP);
        this.flagLanguageMap = this.configurationValue(configuration, PARAMETER_FLAG, Collections.EMPTY_MAP);
        this.locale = this.configurationValue(configuration, PARAMETER_LOCALE_KEY, DEFAULT_LOCALE.getLanguage(), Locale::new);
        if (challengeMap.isEmpty()) {
            this.challenge = new Challenge(this.getClass().getSimpleName(), "", "", "", ChallengeDifficulty.EASY, "");
        } else {
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Challenge.class), new ChallengeDeserializer()).create();
            this.challenge = gson.fromJson(gson.toJson(challengeMap), Challenge.class);
        }
        this.globalPolygonFilter = AtlasEntityPolygonsFilter.forConfiguration(configuration);
        this.checkPolygonFilter = AtlasEntityPolygonsFilter.forConfigurationValues(this.configurationValue(configuration, "filter.polygons.include", Collections.emptyMap()), this.configurationValue(configuration, "filter.multipolygons.include", Collections.emptyMap()), this.configurationValue(configuration, "filter.polygons.exclude", Collections.emptyMap()), this.configurationValue(configuration, "filter.multipolygons.exclude", Collections.emptyMap()));
    }

    @Override
    public Optional<CheckFlag> check(AtlasObject object) {
        try {
            if (this.checkObjectFilter().test(object)) {
                return this.flag(object);
            }
        }
        catch (Exception oops) {
            logger.error(String.format("%s failed on feature %s.", this.getCheckName(), object.getIdentifier()), (Throwable)oops);
        }
        return Optional.empty();
    }

    public final Predicate<AtlasObject> checkObjectFilter() {
        return object -> this.validCheckForObject((AtlasObject)object) && this.tagFilter.test((Taggable)object) && (!(object instanceof AtlasEntity) || this.checkPolygonFilter.test((AtlasEntity)object) && this.globalPolygonFilter.test((AtlasEntity)object)) && (this.acceptPier() || !ManMadeTag.isPier(object));
    }

    @Override
    public void clear() {
        this.clearFlaggedIdentifiers();
    }

    @Override
    public Iterable<CheckFlag> flags(Atlas atlas) {
        return new OptionalIterable<CheckFlag>(Iterables.translate(new MultiIterable(atlas.items(), atlas.relations()), this::check));
    }

    public List<String> getBlacklistCountries() {
        return this.blacklistCountries;
    }

    @Override
    public Challenge getChallenge() {
        return this.challenge;
    }

    @Override
    public final String getCheckName() {
        return this.name;
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getLocalizedInstruction(int index, Object ... objects) {
        String instructionFormat;
        try {
            instructionFormat = this.flagLanguageMap.containsKey(this.getLocale().getLanguage()) ? this.flagLanguageMap.get(this.getLocale().getLanguage()).get(index) : (this.flagLanguageMap.containsKey(DEFAULT_LOCALE.getLanguage()) ? this.flagLanguageMap.get(DEFAULT_LOCALE.getLanguage()).get(index) : this.getFallbackInstructions().get(index));
        }
        catch (IndexOutOfBoundsException exception) {
            instructionFormat = this.getFallbackInstructions().get(index);
        }
        return this.formatInstruction(instructionFormat, objects);
    }

    @Override
    public void logStatus() {
    }

    @Override
    public boolean validCheckForCountry(String country) {
        if (!this.getCountries().isEmpty()) {
            return this.getCountries().contains(country);
        }
        return this.getBlacklistCountries().isEmpty() || !this.getBlacklistCountries().contains(country);
    }

    protected boolean acceptPier() {
        return this.acceptPiers;
    }

    protected void clearFlaggedIdentifiers() {
        this.flaggedIdentifiers.clear();
    }

    protected final String configurationKey(Class type, String key) {
        return this.formatKey(type.getSimpleName(), key);
    }

    protected final String configurationKey(String key) {
        return this.formatKey(this.getCheckName(), key);
    }

    protected <U> U configurationValue(Configuration configuration, String key, U defaultValue) {
        return (U)configuration.get(this.configurationKey(key), defaultValue).value();
    }

    protected <U, V> V configurationValue(Configuration configuration, String key, U defaultValue, Function<U, V> transform) {
        return (V)configuration.get(this.configurationKey(key), defaultValue, transform).value();
    }

    protected CheckFlag createFlag(AtlasObject object, String instruction) {
        return new CheckFlag(this.getTaskIdentifier(object), Collections.singleton(object), Collections.singletonList(instruction));
    }

    protected CheckFlag createFlag(AtlasObject object, String instruction, List<Location> points) {
        return new CheckFlag(this.getTaskIdentifier(object), Collections.singleton(object), Collections.singletonList(instruction), points);
    }

    protected CheckFlag createFlag(Set<AtlasObject> objects, String instruction) {
        return new CheckFlag(this.getTaskIdentifier(objects), objects, Collections.singletonList(instruction));
    }

    protected CheckFlag createFlag(Set<AtlasObject> objects, String instruction, List<Location> points) {
        return new CheckFlag(this.getTaskIdentifier(objects), objects, Collections.singletonList(instruction), points);
    }

    protected abstract Optional<CheckFlag> flag(AtlasObject var1);

    protected List<String> getFallbackInstructions() {
        return Collections.emptyList();
    }

    protected Set<T> getFlaggedIdentifiers() {
        return this.flaggedIdentifiers;
    }

    protected String getTaskIdentifier(AtlasObject object) {
        return new TaskIdentifier(object).toString();
    }

    protected String getTaskIdentifier(Set<AtlasObject> objects) {
        return new TaskIdentifier(objects).toString();
    }

    protected String getUniqueObjectIdentifier(AtlasObject object) {
        if (object instanceof AtlasEntity) {
            return String.format("%s%s", ((AtlasEntity)object).getType().toShortString(), object.getIdentifier());
        }
        return String.format("%s%s", object.getClass().getSimpleName(), object.getIdentifier());
    }

    protected String getUniqueOSMIdentifier(AtlasObject object) {
        if (object instanceof AtlasEntity) {
            return String.format("%s%s", ((AtlasEntity)object).getType().toShortString(), object.getOsmIdentifier());
        }
        return String.format("%s%s", object.getClass().getSimpleName(), object.getIdentifier());
    }

    protected final boolean isFlagged(T identifier) {
        return this.flaggedIdentifiers.contains(identifier);
    }

    protected final void markAsFlagged(T identifier) {
        this.flaggedIdentifiers.add(identifier);
    }

    private String formatInstruction(String format, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return format;
        }
        return new MessageFormat(format).format(objects);
    }

    private String formatKey(String name, String key) {
        return String.format("%s.%s", name, key);
    }
}

