/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

final class RegexpFileFilter
implements FileFilter {
    private final Pattern[] patterns;

    RegexpFileFilter(String str) {
        StringTokenizer st = new StringTokenizer(str, "|", false);
        this.patterns = new Pattern[st.countTokens()];
        for (int i = 0; i < this.patterns.length; ++i) {
            String pattern = st.nextToken();
            if (pattern == null || pattern.trim().length() == 0) continue;
            this.patterns[i] = Pattern.compile(pattern.trim());
        }
    }

    public boolean accept(File file) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (this.patterns[i] == null || !this.patterns[i].matcher(file.getName()).matches()) continue;
            return true;
        }
        return false;
    }
}

