/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.testing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.CompressionActivator;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmosisXmlReaderFromResource
implements RunnableSource {
    private static Logger log = Logger.getLogger(OsmosisXmlReaderFromResource.class.getName());
    private Sink sink;
    private final Resource resource;
    private final boolean enableDateParsing;
    private final CompressionMethod compressionMethod;

    public OsmosisXmlReaderFromResource(Resource resource, boolean enableDateParsing, CompressionMethod compressionMethod) {
        this.resource = resource;
        this.enableDateParsing = enableDateParsing;
        this.compressionMethod = compressionMethod;
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        try {
            this.sink.initialize(Collections.emptyMap());
            inputStream = this.resource.getName() != null && this.resource.getName().equals("-") ? System.in : this.resource.read();
            inputStream = new CompressionActivator(this.compressionMethod).createCompressionInputStream(inputStream);
            SAXParser parser = this.createParser();
            parser.parse(inputStream, (DefaultHandler)new OsmHandler(this.sink, this.enableDateParsing));
            this.sink.complete();
        }
        catch (SAXParseException e) {
            throw new OsmosisRuntimeException("Unable to parse xml resource " + this.resource.getName() + ".  publicId=(" + e.getPublicId() + "), systemId=(" + e.getSystemId() + "), lineNumber=" + e.getLineNumber() + ", columnNumber=" + e.getColumnNumber() + ".", e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to parse XML.", e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read XML file " + this.resource.getName() + ".", e);
        }
        finally {
            this.sink.release();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Unable to close input stream.", e);
                }
                inputStream = null;
            }
        }
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    private SAXParser createParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", e);
        }
    }
}

