/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.statistic.storeless;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.statistic.AbstractStatistic;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;

public class CounterWithStatistic
extends AbstractStatistic {
    private boolean paused = false;
    private Duration duration = Duration.ZERO;
    private Time temporaryTime = this.getStartTime();

    public CounterWithStatistic(Logger logger) {
        super(logger);
    }

    public CounterWithStatistic(Logger logger, long logPrintFrequency, String name) {
        super(logger, logPrintFrequency, name);
    }

    public CounterWithStatistic(Logger logger, String name) {
        super(logger, name);
    }

    public Duration accurateTimeSpent() {
        if (!this.paused) {
            this.duration = this.duration.add(this.temporaryTime.untilNow());
            this.resetTemporaryTime();
        }
        return this.duration;
    }

    public void incrementCount(long count) {
        this.unPause();
        for (long i = 0L; i < count; ++i) {
            long countLocal = this.count();
            this.setCount(++countLocal);
            if (countLocal % this.getLogPrintFrequency() != 0L) continue;
            this.getLog().accept(this.toString());
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void onIncrement(double value) {
        throw new CoreException("Counter doesn't support increment double value {}", value);
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
            this.duration = this.duration.add(this.temporaryTime.untilNow());
        }
    }

    @Override
    public void summary() {
        this.getLog().accept(this.toString());
    }

    public void summaryWithAccurateTimeSpent() {
        this.getLog().accept(this.toStringWithAccurateTimeSpent());
    }

    public void summaryWithoutTimer() {
        this.getLog().accept(this.toStringWithoutTimer());
    }

    public String toStringWithAccurateTimeSpent() {
        return this.getName() + " Count: " + this.getNumberFormat().format(this.count()) + ", Time spent: " + this.accurateTimeSpent();
    }

    public void unPause() {
        if (this.paused) {
            this.paused = false;
            this.resetTemporaryTime();
        }
    }

    @Override
    protected void onIncrement() {
        this.unPause();
    }

    private void resetTemporaryTime() {
        this.temporaryTime = Time.now();
    }
}

