/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.scalars;

import java.io.Serializable;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public final class Surface
implements Serializable {
    public static final Surface MINIMUM = Surface.forDm7Squared(0L);
    public static final Surface MAXIMUM = Surface.forDm7Squared(Long.MAX_VALUE);
    public static final Surface UNIT_METER_SQUARED_ON_EARTH_SURFACE = Surface.forDm7Squared(8082L);
    private static final long serialVersionUID = 9085129200745439319L;
    private final long dm7Squared;

    public static Surface forAngles(Angle angle1, Angle angle2) {
        long dm72;
        long dm71 = angle1.asDm7();
        if (dm71 < 0L) {
            dm71 += 3600000000L;
        }
        if ((dm72 = angle2.asDm7()) < 0L) {
            dm72 += 3600000000L;
        }
        return new Surface(dm71 * dm72);
    }

    public static Surface forDm7Squared(long dm7Squared) {
        return new Surface(dm7Squared);
    }

    private Surface(long dm7Squared) {
        this.dm7Squared = dm7Squared;
    }

    public Surface add(Surface other) {
        return Surface.forDm7Squared(this.asDm7Squared() + other.asDm7Squared());
    }

    public long asDm7Squared() {
        return this.dm7Squared;
    }

    public double asKilometerSquared() {
        double result = (double)this.asDm7Squared() / 3.28280634851262E17 * (Distance.AVERAGE_EARTH_RADIUS.asKilometers() * Distance.AVERAGE_EARTH_RADIUS.asKilometers());
        return result;
    }

    public double asMeterSquared() {
        double result = (double)this.asDm7Squared() / 3.28280634851262E17 * (Distance.AVERAGE_EARTH_RADIUS.asMeters() * Distance.AVERAGE_EARTH_RADIUS.asMeters());
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Surface) {
            Surface that = (Surface)other;
            return that.asDm7Squared() == this.asDm7Squared();
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.dm7Squared);
    }

    public boolean isLargerThan(Surface other) {
        return this.asDm7Squared() > other.asDm7Squared();
    }

    public boolean isLargerThanOrEqualTo(Surface other) {
        return this.asDm7Squared() >= other.asDm7Squared();
    }

    public boolean isLessThan(Surface other) {
        return this.asDm7Squared() < other.asDm7Squared();
    }

    public boolean isLessThanOrEqualTo(Surface other) {
        return this.asDm7Squared() <= other.asDm7Squared();
    }

    public Surface scaleBy(double factor) {
        if (factor < 0.0) {
            throw new IllegalArgumentException("Scale factor must not be a negative number");
        }
        return Surface.forDm7Squared((long)((double)this.asDm7Squared() * factor));
    }

    public Surface subtract(Surface other) {
        if (this.isLargerThanOrEqualTo(other)) {
            return Surface.forDm7Squared(this.asDm7Squared() - other.asDm7Squared());
        }
        throw new IllegalArgumentException("Invalid surfaces for performing subtraction");
    }

    public String toString() {
        return this.asDm7Squared() + " dm7^2";
    }
}

