/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.scalars;

import java.io.Serializable;
import org.openstreetmap.atlas.exception.CoreException;

public final class Duration
implements Serializable {
    private static final long serialVersionUID = 8306012362496627267L;
    private static final long NANOSECONDS_PER_MILLISECONDS = 1000000L;
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long MINUTES_PER_HOUR = 60L;
    public static final Duration ONE_DAY = Duration.hours(24.0);
    public static final Duration ONE_HOUR = Duration.hours(1.0);
    public static final Duration ONE_MINUTE = Duration.minutes(1.0);
    public static final Duration ONE_SECOND = Duration.seconds(1.0);
    public static final Duration ZERO = Duration.milliseconds(0L);
    public static final Duration MAXIMUM = Duration.milliseconds(Long.MAX_VALUE);
    private final long milliseconds;

    public static Duration hours(double hours) {
        return Duration.minutes(hours * 60.0);
    }

    public static Duration milliseconds(long milliseconds) {
        return new Duration(milliseconds);
    }

    public static Duration minutes(double minutes) {
        return Duration.seconds(minutes * 60.0);
    }

    public static Duration seconds(double seconds) {
        return Duration.milliseconds(Math.round(seconds * 1000.0));
    }

    private Duration(long milliseconds) {
        if (milliseconds < 0L) {
            throw new CoreException("Cannot have a negative duration");
        }
        this.milliseconds = milliseconds;
    }

    public Duration add(Duration that) {
        return new Duration(this.milliseconds + that.milliseconds);
    }

    public double asHours() {
        return this.asMinutes() / 60.0;
    }

    public long asMilliseconds() {
        return this.milliseconds;
    }

    public double asMinutes() {
        return this.asSeconds() / 60.0;
    }

    public double asSeconds() {
        return (double)this.asMilliseconds() / 1000.0;
    }

    public Duration difference(Duration that) {
        return new Duration(Math.abs(that.milliseconds - this.milliseconds));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Duration) {
            return this.asMilliseconds() == ((Duration)obj).asMilliseconds();
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.milliseconds);
    }

    public boolean isCloseTo(Duration that, Duration safe) {
        return this.difference(that).isLessThanOrEqualsTo(safe);
    }

    public boolean isLessThan(Duration that) {
        return this.milliseconds < that.milliseconds;
    }

    public boolean isLessThanOrEqualsTo(Duration that) {
        return this.milliseconds <= that.milliseconds;
    }

    public boolean isMoreThan(Duration that) {
        return this.milliseconds > that.milliseconds;
    }

    public boolean isMoreThanOrEqualsTo(Duration that) {
        return this.milliseconds >= that.milliseconds;
    }

    public long millisecondsOfSecond() {
        return this.asMilliseconds() % 1000L;
    }

    public long nanosecondsOfSecond() {
        return this.millisecondsOfSecond() * 1000000L;
    }

    public void sleep() {
        try {
            Thread.sleep(this.milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not sleep " + this, e);
        }
    }

    public String toString() {
        if (this.milliseconds < 1000L) {
            return this.asMilliseconds() + " milliseconds";
        }
        if (this.milliseconds < 60000L) {
            return String.format("%.3f seconds", this.asSeconds());
        }
        return String.format("%.3f minutes", this.asMinutes());
    }
}

