/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry {
    private static final Logger logger = LoggerFactory.getLogger(Retry.class);
    private static final Predicate<Throwable> FILTER_NONE = throwable -> false;
    private final int retries;
    private final Duration waitBeforeRetry;
    private boolean quiet = false;

    public Retry(int retries, Duration waitBeforeRetry) {
        this.retries = retries >= 0 ? retries : 0;
        this.waitBeforeRetry = waitBeforeRetry;
    }

    public void run(Runnable runnable) {
        this.run(runnable, null, FILTER_NONE);
    }

    public void run(Runnable runnable, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        this.run(runnable, null, exceptionsWhichShouldBreakDirectly);
    }

    public void run(Runnable runnable, Runnable runBeforeRetry) {
        this.run(runnable, runBeforeRetry, FILTER_NONE);
    }

    public void run(Runnable runnable, Runnable runBeforeRetry, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        this.run(() -> {
            runnable.run();
            return "";
        }, runBeforeRetry, exceptionsWhichShouldBreakDirectly);
    }

    public <Value> Value run(Supplier<Value> callable) {
        return this.run(callable, null, FILTER_NONE);
    }

    public <Value> Value run(Supplier<Value> callable, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        return this.run(callable, null, exceptionsWhichShouldBreakDirectly);
    }

    public <Value> Value run(Supplier<Value> callable, Runnable runBeforeRetry) {
        return this.run(callable, runBeforeRetry, FILTER_NONE);
    }

    public <Value> Value run(Supplier<Value> callable, Runnable runBeforeRetry, Predicate<Throwable> exceptionsWhichShouldBreakDirectly) {
        int retry = 0;
        Value result = null;
        boolean success = false;
        Throwable lastError = null;
        while (!success && retry <= this.retries) {
            try {
                if (retry > 0 && runBeforeRetry != null) {
                    runBeforeRetry.run();
                }
                result = callable.get();
                success = true;
            }
            catch (Throwable throwable) {
                if (exceptionsWhichShouldBreakDirectly.test(throwable)) {
                    throw throwable;
                }
                if (!this.quiet) {
                    logger.error("Failed retry number " + retry, throwable);
                }
                lastError = throwable;
                ++retry;
                this.waitBeforeRetry.sleep();
            }
        }
        if (success) {
            return result;
        }
        throw new RuntimeException("Failed execution after " + retry + " retries.", lastError);
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }
}

