/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.matching;

import java.io.Serializable;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class NameMatcher
implements Serializable,
Predicate<String> {
    private static final long serialVersionUID = 5446378702031541204L;
    private static final int DEFAULT_LEVENSHTEIN_DISTANCE_THRESHOLD = 1;
    private final String sourceName;
    private boolean fuzzyMatch = false;
    private int lavenshteinDistanceThreshold = 1;
    private boolean matchNull = false;
    private boolean exactMatch = false;

    public NameMatcher(String sourceName) {
        this.sourceName = sourceName;
    }

    public NameMatcher matchExactly() {
        this.exactMatch = true;
        this.fuzzyMatch = false;
        return this;
    }

    public NameMatcher matchNulls() {
        this.matchNull = true;
        return this;
    }

    public NameMatcher matchSimilar() {
        this.exactMatch = false;
        this.fuzzyMatch = true;
        return this;
    }

    public NameMatcher matchSimilar(int lavenshteinDistanceThreshold) {
        this.exactMatch = false;
        this.fuzzyMatch = true;
        this.lavenshteinDistanceThreshold = lavenshteinDistanceThreshold;
        return this;
    }

    @Override
    public boolean test(String candidateName) {
        if (candidateName == null) {
            return this.matchNull;
        }
        if (this.exactMatch) {
            return candidateName.equals(this.sourceName);
        }
        if (this.fuzzyMatch) {
            return this.nameFuzzyMatch(this.sourceName, candidateName);
        }
        return candidateName.equalsIgnoreCase(this.sourceName);
    }

    private boolean nameFuzzyMatch(String nameA, String nameB) {
        return nameA.equalsIgnoreCase(nameB) || StringUtils.getLevenshteinDistance(nameA, nameB, this.lavenshteinDistanceThreshold) != -1;
    }
}

