/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import org.openstreetmap.atlas.utilities.arrays.IntegerArray;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.maps.LargeMap;

public class LongToIntegerMap
extends LargeMap<Long, Integer> {
    private static final long serialVersionUID = 346161750484489066L;

    public LongToIntegerMap(long maximumSize) {
        super(maximumSize);
    }

    public LongToIntegerMap(long maximumSize, int hashSize) {
        super(maximumSize, hashSize);
    }

    public LongToIntegerMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        super(name, maximumSize, hashSize, keyMemoryBlockSize, keySubArraySize, valueMemoryBlockSize, valueSubArraySize);
    }

    @Override
    protected LargeArray<Long> createKeys(int memoryBlockSize, int subArraySize) {
        LongArray result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArray(this.getMaximumSize());
        result.withName(this.getName() + " - Keys");
        return result;
    }

    @Override
    protected LargeArray<Integer> createValues(int memoryBlockSize, int subArraySize) {
        IntegerArray result = memoryBlockSize > 0 && subArraySize > 0 ? new IntegerArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new IntegerArray(this.getMaximumSize());
        result.withName(this.getName() + " - Values");
        return result;
    }
}

