/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.jsoncompare;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skyscreamer.jsonassert.JSONCompareResult;

class RegularExpressionJSONCompareResult
extends JSONCompareResult {
    private final List<Pattern> searchPatterns;

    RegularExpressionJSONCompareResult(List<Pattern> searchPatterns) {
        this.searchPatterns = searchPatterns;
    }

    @Override
    public JSONCompareResult fail(String field, Object expected, Object actual) {
        if (!this.matches(field)) {
            super.fail(field, expected, actual);
        }
        return this;
    }

    @Override
    public JSONCompareResult missing(String field, Object expected) {
        if (!this.matches(String.format("%s.%s", field, expected))) {
            super.missing(field, expected);
        }
        return this;
    }

    @Override
    public JSONCompareResult unexpected(String field, Object value) {
        if (!this.matches(String.format("%s.%s", field, value))) {
            super.unexpected(field, value);
        }
        return this;
    }

    private boolean matches(String compareMe) {
        return this.searchPatterns.stream().map(pattern -> pattern.matcher(compareMe)).anyMatch(Matcher::matches);
    }
}

