/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.graphs;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.maps.LinkedMultiMap;

public class DirectedAcyclicGraph<V>
implements Serializable {
    private static final long serialVersionUID = -1980678458375645486L;
    private final LinkedMultiMap<V, V> inMap = new LinkedMultiMap();
    private final LinkedMultiMap<V, V> outMap = new LinkedMultiMap();

    public boolean addEdge(V origin, V target) {
        if (origin == null || target == null) {
            throw new CoreException("Origin and Target for directed Acyclic graph must not be null");
        }
        if (this.hasPath(target, origin)) {
            return false;
        }
        this.outMap.add(origin, target);
        this.outMap.add(target, null);
        this.inMap.add(target, origin);
        this.inMap.add(origin, null);
        return true;
    }

    public void addVertex(V vertex) {
        if (vertex == null) {
            throw new CoreException("Cannot add a null vertex to the Directed Acyclic Graph.");
        }
        this.outMap.put(vertex, null);
        this.inMap.put(vertex, null);
    }

    public boolean contains(V vertex) {
        return this.outMap.containsKey(vertex) || this.inMap.containsKey(vertex);
    }

    public Set<V> getChildren(V parent) {
        return Collections.unmodifiableSet(this.outMap.get(parent));
    }

    public int getDeepestLevel(V vertex) {
        return this.getDeepestLevel(vertex, 1);
    }

    public Set<V> getParents(V child) {
        return Collections.unmodifiableSet(this.inMap.get(child));
    }

    public Set<V> getSinks() {
        return this.getZeroEdgeVertices(this.outMap);
    }

    public Set<V> getSources() {
        return this.getZeroEdgeVertices(this.inMap);
    }

    public Stack<V> getTopologicalSortedList() {
        Stack stack = new Stack();
        HashSet visited = new HashSet();
        this.inMap.forEach((inVertex, outVertex) -> {
            if (!visited.contains(inVertex)) {
                this.topologicalSort(inVertex, visited, stack);
            }
        });
        return stack;
    }

    public boolean hasPath(V start, V end) {
        if (start == end) {
            return true;
        }
        Object children = this.outMap.get(start);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (!this.hasPath(iterator.next(), end)) continue;
            return true;
        }
        return false;
    }

    public boolean isSink(V vertex) {
        return this.outMap.get(vertex).isEmpty();
    }

    public boolean isSource(V vertex) {
        return this.inMap.get(vertex).isEmpty();
    }

    public void removeVertex(V vertex) {
        Object origins;
        Object targets = this.outMap.remove(vertex);
        if (targets != null) {
            targets.forEach(target -> this.outMap.remove(target, vertex));
        }
        if ((origins = this.inMap.remove(vertex)) != null) {
            origins.forEach(origin -> this.inMap.remove(origin, vertex));
        }
    }

    public String toString() {
        return "[Out: " + this.outMap.toString() + ", In: " + this.inMap.toString() + "]";
    }

    private int getDeepestLevel(V vertex, int level) {
        if (this.isSource(vertex)) {
            return level;
        }
        Set<V> parents = this.getParents(vertex);
        int nextLevel = level;
        for (V parent : parents) {
            nextLevel = Math.max(nextLevel, this.getDeepestLevel(parent, level) + 1);
        }
        return nextLevel;
    }

    private Set<V> getZeroEdgeVertices(LinkedMultiMap<V, V> map) {
        Set<V> mapKeys = map.keySet();
        LinkedHashSet zeroEdges = new LinkedHashSet(mapKeys.size());
        mapKeys.stream().filter(key -> map.get(key).isEmpty()).forEach(key -> zeroEdges.add(key));
        return zeroEdges;
    }

    private void topologicalSort(V current, Set<V> visited, Stack<V> stack) {
        visited.add(current);
        this.getChildren(current).iterator().forEachRemaining(child -> {
            if (!visited.contains(child)) {
                this.topologicalSort(child, visited, stack);
            }
        });
        stack.push(current);
    }
}

