/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.filters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.converters.PolygonStringFormat;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.filters.IntersectionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasEntityPolygonsFilter
implements Predicate<AtlasEntity>,
Serializable {
    public static final String EXCLUDED_MULTIPOLYGONS_KEY = "filter.multipolygons.exclude";
    public static final String EXCLUDED_POLYGONS_KEY = "filter.polygons.exclude";
    public static final String INCLUDED_MULTIPOLYGONS_KEY = "filter.multipolygons.include";
    public static final String INCLUDED_POLYGONS_KEY = "filter.polygons.include";
    private static final Logger logger = LoggerFactory.getLogger(AtlasEntityPolygonsFilter.class);
    private static final long serialVersionUID = -3474748398986569205L;
    private Type filterType;
    private RTree<GeometricSurface> geometricSurfaces = new RTree();
    private IntersectionPolicy intersectionPolicy;

    public static Collection<GeometricSurface> createSurfaceCollection(Collection<? extends GeometricSurface> collection1, Collection<? extends GeometricSurface> collection2) {
        ArrayList<GeometricSurface> returnCollection = new ArrayList<GeometricSurface>();
        returnCollection.addAll(collection1);
        returnCollection.addAll(collection2);
        return returnCollection;
    }

    public static AtlasEntityPolygonsFilter forConfiguration(Configuration configuration, IntersectionPolicy intersectionPolicy) {
        return AtlasEntityPolygonsFilter.forConfigurationValues((Map)configuration.get(INCLUDED_POLYGONS_KEY).value(), (Map)configuration.get(INCLUDED_MULTIPOLYGONS_KEY).value(), (Map)configuration.get(EXCLUDED_POLYGONS_KEY).value(), (Map)configuration.get(EXCLUDED_MULTIPOLYGONS_KEY).value(), intersectionPolicy);
    }

    public static AtlasEntityPolygonsFilter forConfiguration(Configuration configuration) {
        return AtlasEntityPolygonsFilter.forConfiguration(configuration, IntersectionPolicy.DEFAULT_INTERSECTION_POLICY);
    }

    public static AtlasEntityPolygonsFilter forConfigurationValues(Map<String, List<String>> includePolygonMap, Map<String, List<String>> includeMultiPolygonMap, Map<String, List<String>> excludePolygonMap, Map<String, List<String>> excludeMultiPolygonMap) {
        return AtlasEntityPolygonsFilter.forConfigurationValues(includePolygonMap, includeMultiPolygonMap, excludePolygonMap, excludeMultiPolygonMap, IntersectionPolicy.DEFAULT_INTERSECTION_POLICY);
    }

    public static AtlasEntityPolygonsFilter forConfigurationValues(Map<String, List<String>> includePolygonMap, Map<String, List<String>> includeMultiPolygonMap, Map<String, List<String>> excludePolygonMap, Map<String, List<String>> excludeMultiPolygonMap, IntersectionPolicy intersectionPolicy) {
        List<MultiPolygon> excludeMultiPolygons;
        List<Polygon> includePolygons = includePolygonMap != null ? AtlasEntityPolygonsFilter.getPolygonsFromFormatMap(includePolygonMap) : Collections.EMPTY_LIST;
        List<MultiPolygon> includeMultiPolygons = includeMultiPolygonMap != null ? AtlasEntityPolygonsFilter.getMultiPolygonsFromFormatMap(includeMultiPolygonMap) : Collections.EMPTY_LIST;
        List<Polygon> excludePolygons = excludePolygonMap != null ? AtlasEntityPolygonsFilter.getPolygonsFromFormatMap(excludePolygonMap) : Collections.EMPTY_LIST;
        List<MultiPolygon> list = excludeMultiPolygons = excludeMultiPolygonMap != null ? AtlasEntityPolygonsFilter.getMultiPolygonsFromFormatMap(excludeMultiPolygonMap) : Collections.EMPTY_LIST;
        if (!includePolygons.isEmpty() || !includeMultiPolygons.isEmpty()) {
            if (!excludePolygons.isEmpty() || !excludeMultiPolygons.isEmpty()) {
                logger.warn("Ignoring exclude polygons and multipolygons passed through configuration");
            }
            return Type.INCLUDE.polygonsAndMultiPolygons(intersectionPolicy, includePolygons, includeMultiPolygons);
        }
        return Type.EXCLUDE.polygonsAndMultiPolygons(intersectionPolicy, excludePolygons, excludeMultiPolygons);
    }

    private static List<MultiPolygon> getMultiPolygonsFromFormatMap(Map<String, List<String>> multiPolygonLists) {
        if (multiPolygonLists.isEmpty()) {
            return Collections.emptyList();
        }
        return multiPolygonLists.entrySet().stream().flatMap(formatAndMultiPolygonStrings -> ((List)formatAndMultiPolygonStrings.getValue()).stream().map(PolygonStringFormat.getEnumForFormat((String)formatAndMultiPolygonStrings.getKey()).getMultiPolygonConverter()).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private static List<Polygon> getPolygonsFromFormatMap(Map<String, List<String>> polygonLists) {
        if (polygonLists.isEmpty()) {
            return Collections.emptyList();
        }
        return polygonLists.entrySet().stream().flatMap(formatAndPolygonStrings -> ((List)formatAndPolygonStrings.getValue()).stream().map(PolygonStringFormat.getEnumForFormat((String)formatAndPolygonStrings.getKey()).getPolygonConverter()).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private AtlasEntityPolygonsFilter(Type filterType, Collection<? extends GeometricSurface> geometricSurfaces) {
        this(filterType, IntersectionPolicy.DEFAULT_INTERSECTION_POLICY, geometricSurfaces);
    }

    private AtlasEntityPolygonsFilter(Type filterType, IntersectionPolicy intersectionPolicy, Collection<? extends GeometricSurface> geometricSurfaces) {
        this.filterType = filterType;
        this.intersectionPolicy = intersectionPolicy;
        this.geometricSurfaces = RTree.forLocated(geometricSurfaces == null ? Collections.EMPTY_SET : geometricSurfaces);
    }

    @Override
    public boolean test(AtlasEntity object) {
        return this.noSurfaces().or(this.isIncluded()).or(this.isNotExcluded()).test(object);
    }

    private Predicate<AtlasEntity> isIncluded() {
        return entity -> this.filterType == Type.INCLUDE && this.geometricSurfaces.get(entity.bounds()).stream().anyMatch(geometricSurface -> this.intersectionPolicy.geometricSurfaceEntityIntersecting((GeometricSurface)geometricSurface, (AtlasEntity)entity));
    }

    private Predicate<AtlasEntity> isNotExcluded() {
        return entity -> this.filterType == Type.EXCLUDE && this.geometricSurfaces.get(entity.bounds()).stream().noneMatch(geometricSurface -> this.intersectionPolicy.geometricSurfaceEntityIntersecting((GeometricSurface)geometricSurface, (AtlasEntity)entity));
    }

    private Predicate<AtlasEntity> noSurfaces() {
        return entity -> this.geometricSurfaces.isEmpty();
    }

    public static enum Type {
        INCLUDE,
        EXCLUDE;


        public AtlasEntityPolygonsFilter geometricSurfaces(IntersectionPolicy intersectionPolicy, Collection<GeometricSurface> geometricSurfaces) {
            return new AtlasEntityPolygonsFilter(this, intersectionPolicy, geometricSurfaces);
        }

        public AtlasEntityPolygonsFilter geometricSurfaces(Collection<GeometricSurface> geometricSurfaces) {
            return new AtlasEntityPolygonsFilter(this, geometricSurfaces);
        }

        public AtlasEntityPolygonsFilter multiPolygons(Collection<MultiPolygon> multiPolygons) {
            return new AtlasEntityPolygonsFilter(this, multiPolygons);
        }

        public AtlasEntityPolygonsFilter multiPolygons(IntersectionPolicy intersectionPolicy, Collection<MultiPolygon> multiPolygons) {
            return new AtlasEntityPolygonsFilter(this, intersectionPolicy, multiPolygons);
        }

        public AtlasEntityPolygonsFilter polygons(Collection<Polygon> polygons) {
            return new AtlasEntityPolygonsFilter(this, polygons);
        }

        public AtlasEntityPolygonsFilter polygons(IntersectionPolicy intersectionPolicy, Collection<Polygon> polygons) {
            return new AtlasEntityPolygonsFilter(this, intersectionPolicy, polygons);
        }

        public AtlasEntityPolygonsFilter polygonsAndMultiPolygons(Collection<Polygon> polygons, Collection<MultiPolygon> multiPolygons) {
            return new AtlasEntityPolygonsFilter(this, AtlasEntityPolygonsFilter.createSurfaceCollection(polygons, multiPolygons));
        }

        public AtlasEntityPolygonsFilter polygonsAndMultiPolygons(IntersectionPolicy intersectionPolicy, Collection<Polygon> polygons, Collection<MultiPolygon> multiPolygons) {
            return new AtlasEntityPolygonsFilter(this, intersectionPolicy, AtlasEntityPolygonsFilter.createSurfaceCollection(polygons, multiPolygons));
        }
    }
}

