/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

class ConfigurationDeserializer
extends JsonDeserializer<Map<String, Object>> {
    ConfigurationDeserializer() {
    }

    @Override
    public Map<String, Object> deserialize(JsonParser jacksonParser, DeserializationContext context) throws IOException {
        return this.deserializeObject(jacksonParser, context);
    }

    private ArrayList<Object> deserializeArray(JsonParser jacksonParser, DeserializationContext context) throws IOException {
        if (jacksonParser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new JsonMappingException((Closeable)jacksonParser, "Invalid JSON format.");
        }
        jacksonParser.nextToken();
        ArrayList<Object> list = new ArrayList<Object>();
        while (jacksonParser.getCurrentToken() != JsonToken.END_ARRAY) {
            list.add(this.deserializeValue(jacksonParser, context));
            jacksonParser.nextToken();
        }
        return list;
    }

    private Map<String, Object> deserializeObject(JsonParser jacksonParser, DeserializationContext context) throws IOException {
        if (jacksonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonMappingException((Closeable)jacksonParser, "Invalid JSON format.");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (jacksonParser.nextToken() != JsonToken.END_OBJECT) {
            String dotKey = jacksonParser.getCurrentName();
            Map<String, Object> locatedMap = this.locateMap(dotKey, map, jacksonParser);
            int lastDot = dotKey.lastIndexOf(".");
            String key = lastDot > 0 && lastDot < dotKey.length() ? dotKey.substring(lastDot + 1) : dotKey;
            jacksonParser.nextToken();
            Object deserializedValue = this.deserializeValue(jacksonParser, context);
            locatedMap.put(key, deserializedValue);
        }
        return map;
    }

    private Object deserializeValue(JsonParser jacksonParser, DeserializationContext context) throws IOException {
        switch (jacksonParser.getCurrentToken()) {
            case START_OBJECT: {
                return this.deserializeObject(jacksonParser, context);
            }
            case START_ARRAY: {
                return this.deserializeArray(jacksonParser, context);
            }
            case VALUE_STRING: {
                return jacksonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                return jacksonParser.getLongValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return jacksonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        return context.handleUnexpectedToken(Object.class, jacksonParser);
    }

    private Map<String, Object> locateMap(String dotKey, Map<String, Object> map, JsonParser jacksonParser) throws IOException {
        int dotIndex = dotKey.indexOf(".");
        if (dotIndex > 0 && dotIndex < dotKey.length()) {
            String part = dotKey.substring(0, dotIndex);
            String remaining = dotKey.substring(dotIndex + 1);
            LinkedHashMap nextMap = map.getOrDefault(part, new LinkedHashMap());
            if (!(nextMap instanceof Map)) {
                throw new JsonMappingException((Closeable)jacksonParser, "Invalid JSON format.");
            }
            map.put(part, nextMap);
            return this.locateMap(remaining, nextMap, jacksonParser);
        }
        return map;
    }
}

