/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class StringList
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = -7923796535827613632L;
    private final List<String> list;

    public static StringList split(String item, String separator) {
        return StringList.split(item, separator, 0);
    }

    public static StringList split(String item, String separator, int limit) {
        return new StringList(Iterables.asList(item.split(Pattern.quote(separator), limit)));
    }

    public static StringList splitByRegex(String item, String separator) {
        return StringList.splitByRegex(item, separator, 0);
    }

    public static StringList splitByRegex(String item, String regex, int limit) {
        return new StringList(Iterables.asList(item.split(regex, limit)));
    }

    public StringList() {
        this.list = new ArrayList<String>();
    }

    public StringList(Iterable<String> list) {
        this.list = Iterables.asList(list);
    }

    public StringList(List<String> list) {
        this.list = list;
    }

    public StringList(String ... array) {
        this.list = Iterables.asList(array);
    }

    public void add(Object string) {
        this.list.add(String.valueOf(string));
    }

    public void add(String string) {
        this.list.add(string);
    }

    public void addAll(Iterable<String> split) {
        split.forEach(this::add);
    }

    public boolean contains(String item) {
        for (String candidate : this) {
            if (!candidate.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> first() {
        if (this.size() <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.get(0));
    }

    public synchronized String get(int index) {
        if (index >= this.size()) {
            throw new CoreException("Cannot get item out of bounds: {} in size = {}", index, this.size());
        }
        return this.list.get(index);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    public String join(String separator) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String string : this) {
            result.append(string);
            if (++index >= this.size()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public Optional<String> last() {
        if (this.size() <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.get(this.size() - 1));
    }

    public int size() {
        return this.list.size();
    }

    public boolean startsWithContains(String item) {
        for (String candidate : this) {
            if (!item.startsWith(candidate)) continue;
            return true;
        }
        return false;
    }

    public Stream<String> stream() {
        return this.list.stream();
    }

    public String toString() {
        return this.list.toString();
    }
}

