/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.Iterator;
import java.util.Optional;

public class OptionalIterable<T>
implements Iterable<T> {
    private final Iterable<Optional<T>> iterable;

    public OptionalIterable(Iterable<Optional<T>> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Optional<T>> iterator;
            private Optional<T> previousElement;
            {
                this.iterator = OptionalIterable.this.iterable.iterator();
                this.previousElement = Optional.empty();
            }

            @Override
            public boolean hasNext() {
                if (this.previousElement.isPresent()) {
                    return true;
                }
                while (this.iterator.hasNext()) {
                    Optional current = this.iterator.next();
                    if (!current.isPresent()) continue;
                    this.previousElement = current;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.previousElement.isPresent()) {
                    Object returnElement = this.previousElement.get();
                    this.previousElement = Optional.empty();
                    return returnElement;
                }
                while (this.iterator.hasNext()) {
                    Optional item = this.iterator.next();
                    if (!item.isPresent()) continue;
                    return item.get();
                }
                return null;
            }
        };
    }
}

