/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;

public class JoinedCollection {
    private final Object[] elements;

    public JoinedCollection(int originalSize) {
        this.elements = new Object[originalSize];
        for (int index = 0; index < this.elements.length; ++index) {
            this.elements[index] = null;
        }
    }

    public <Type> Type get(int index) throws ClassCastException, CoreException {
        if (index >= 0 && index < this.elements.length) {
            return (Type)this.elements[index];
        }
        throw new CoreException("Invalid index {}, needs to be value between -1 and {}", index, this.elements.length);
    }

    public <Type> Optional<Type> getOption(int index) throws ClassCastException {
        Type returnType = this.get(index);
        if (returnType == null) {
            return Optional.empty();
        }
        return Optional.of(returnType);
    }

    public <Type> void set(int index, Type value) throws CoreException {
        if (index < 0 || index >= this.elements.length) {
            throw new CoreException("Invalid index {}, needs to be value between -1 and {}", index, this.elements.length);
        }
        this.elements[index] = value;
    }
}

