/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class FixedSizePriorityQueue<E>
extends AbstractQueue<E> {
    private final int maximumSize;
    private final PriorityQueue<E> priorityQueue;

    public FixedSizePriorityQueue(int maximumSize) {
        this.maximumSize = maximumSize;
        this.priorityQueue = new PriorityQueue(maximumSize + 1);
    }

    public FixedSizePriorityQueue(int maximumSize, Comparator<? super E> comparator) {
        this.maximumSize = maximumSize;
        this.priorityQueue = new PriorityQueue<E>(maximumSize + 1, comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.priorityQueue.iterator();
    }

    @Override
    public boolean offer(E e) {
        boolean flag = this.priorityQueue.offer(e);
        if (this.priorityQueue.size() > this.maximumSize) {
            this.poll();
        }
        return flag;
    }

    @Override
    public E peek() {
        return this.priorityQueue.peek();
    }

    @Override
    public E poll() {
        return this.priorityQueue.poll();
    }

    @Override
    public int size() {
        return this.priorityQueue.size();
    }
}

