/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractHDFSOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class HDFSCheckIfFileExistsOperation
extends AbstractHDFSOperation {
    @Override
    public HDFSCheckIfFileExistsOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public boolean exists(Path remotePath) throws InterruptedException, IOException {
        if (remotePath == null) {
            throw new IllegalArgumentException("remotePath can't be null");
        }
        this.prepareSSH().addArgs("-stat", this.preparePath(remotePath.toString()));
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        return results.getReturnValue() == 0;
    }

    @Override
    public HDFSCheckIfFileExistsOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public HDFSCheckIfFileExistsOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }

    @Override
    public HDFSCheckIfFileExistsOperation withConfiguration(String configuration) {
        super.withConfiguration(configuration);
        return this;
    }
}

