/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class DeepLSOperation
extends AbstractOperation {
    @Override
    public DeepLSOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public List<Path> list(Path remotePath) throws InterruptedException, IOException {
        if (remotePath == null) {
            throw new IllegalArgumentException("remotePath can't be null");
        }
        this.ssh().addArgs("find", remotePath.toString(), "-type", "f");
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        if (results.getReturnValue() == 1) {
            throw new CoreException("Error: {}@{}:{} doesn't exist", this.getUser(), this.getHost(), remotePath);
        }
        return Arrays.asList(results.getOutput().split("\n")).stream().map(child -> remotePath.resolve((String)child)).collect(Collectors.toList());
    }

    @Override
    public DeepLSOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public DeepLSOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }
}

