/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching.strategies;

import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.strategies.AbstractCachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTemporaryFileCachingStrategy
extends AbstractCachingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SystemTemporaryFileCachingStrategy.class);
    private static final String PROPERTY_LOCAL_TEMPORARY_DIRECTORY = "java.io.tmpdir";
    private static final String TEMPORARY_DIRECTORY_STRING = System.getProperty("java.io.tmpdir");

    @Override
    public Optional<Resource> attemptFetch(URI resourceURI, Function<URI, Resource> defaultFetcher) {
        if (TEMPORARY_DIRECTORY_STRING == null) {
            logger.error("Failed to read property {}, skipping cache fetch...", (Object)PROPERTY_LOCAL_TEMPORARY_DIRECTORY);
            return Optional.empty();
        }
        if (resourceURI == null) {
            logger.warn("resourceURI was null, skipping cache fetch...");
            return Optional.empty();
        }
        Path temporaryDirectory = Paths.get(TEMPORARY_DIRECTORY_STRING, new String[0]);
        String cachedFileName = this.getUUIDForResourceURI(resourceURI).toString();
        Path cachedFilePath = Paths.get(temporaryDirectory.toString(), cachedFileName);
        File cachedFile = new File(cachedFilePath.toString());
        this.attemptToCacheFileLocally(cachedFile, defaultFetcher, resourceURI);
        if (cachedFile.exists()) {
            logger.trace("Cache hit on resource {}, returning local copy", (Object)resourceURI);
            return Optional.of(cachedFile);
        }
        logger.warn("Unexpected cache miss on resource {}", (Object)resourceURI);
        return Optional.empty();
    }

    @Override
    public String getName() {
        return "SystemTemporaryFileCachingStrategy";
    }

    @Override
    public void invalidate() {
        throw new UnsupportedOperationException("Operation not supported at this time.");
    }

    private void attemptToCacheFileLocally(File cachedFile, Function<URI, Resource> defaultFetcher, URI resourceURI) {
        if (!cachedFile.exists()) {
            logger.trace("Attempting to cache resource {} in temporary file {}", (Object)resourceURI, (Object)cachedFile.toString());
            Resource resourceFromDefaultFetcher = defaultFetcher.apply(resourceURI);
            File temporaryLocalFile = File.temporary();
            try {
                resourceFromDefaultFetcher.copyTo(temporaryLocalFile);
            }
            catch (Exception exception) {
                logger.error("Something went wrong copying {} to temporary local file {}, trace {}", new Object[]{resourceFromDefaultFetcher.toString(), temporaryLocalFile.toString(), exception});
                return;
            }
            if (!cachedFile.exists()) {
                try {
                    Path temporaryLocalFilePath = Paths.get(temporaryLocalFile.getPath(), new String[0]);
                    Path cachedFilePath = Paths.get(cachedFile.getPath(), new String[0]);
                    Files.move(temporaryLocalFilePath, cachedFilePath, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (FileAlreadyExistsException exception) {
                    logger.trace("File {} is already cached", (Object)cachedFile.toString());
                    return;
                }
                catch (Exception exception) {
                    logger.error("Something went wrong moving {} to {}, trace {}", new Object[]{temporaryLocalFile.toString(), cachedFile.toString(), exception});
                }
            }
        }
    }
}

