/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching;

import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentResourceCache.class);
    private final CachingStrategy cachingStrategy;
    private final Function<URI, Resource> fetcher;

    public ConcurrentResourceCache(CachingStrategy cachingStrategy, Function<URI, Resource> fetcher) {
        this.cachingStrategy = cachingStrategy;
        this.fetcher = fetcher;
    }

    public Optional<Resource> get(String resourceURIString) {
        return this.get(URI.create(resourceURIString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Resource> get(URI resourceURI) {
        Optional<Resource> cachedResource;
        ConcurrentResourceCache concurrentResourceCache = this;
        synchronized (concurrentResourceCache) {
            cachedResource = this.cachingStrategy.attemptFetch(resourceURI, this.fetcher);
        }
        if (!cachedResource.isPresent()) {
            logger.warn("Cache fetch failed, falling back to default fetcher...");
            concurrentResourceCache = this;
            synchronized (concurrentResourceCache) {
                cachedResource = Optional.ofNullable(this.fetcher.apply(resourceURI));
            }
        }
        return cachedResource;
    }
}

