/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class IntegerArray
extends LargeArray<Integer> {
    private static final long serialVersionUID = -6015640040842668449L;

    public IntegerArray(long maximumSize) {
        super(maximumSize);
    }

    public IntegerArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    @Override
    protected PrimitiveArray<Integer> getNewArray(int size) {
        return new IntegerPrimitiveArray(size);
    }

    public static class IntegerPrimitiveArray
    extends PrimitiveArray<Integer> {
        private static final long serialVersionUID = -3932998946137654750L;
        private final int[] array = new int[this.size()];

        public IntegerPrimitiveArray(int size) {
            super(size);
        }

        @Override
        public Integer get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<Integer> getNewArray(int size) {
            return new IntegerPrimitiveArray(size);
        }

        @Override
        public void set(int index, Integer item) {
            this.array[index] = item;
        }
    }
}

