/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.archive;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOUtils;
import org.openstreetmap.atlas.streaming.NotifyingIOUtils;
import org.openstreetmap.atlas.utilities.archive.AbstractArchiverOrExtractor;
import org.openstreetmap.atlas.utilities.archive.ArchiveStorageProfileDelegate;
import org.openstreetmap.atlas.utilities.archive.ArchiveVetoDelegate;
import org.openstreetmap.atlas.utilities.archive.ArchiverEventListener;
import org.openstreetmap.atlas.utilities.archive.DefaultZipVetoDelegate;

public final class Archiver
extends AbstractArchiverOrExtractor<Archiver> {
    private final ArchiveOutputStream archiveOutputStream;
    private int errorCount;
    private ArchiveStorageProfileDelegate storageDelegate;

    public static Archiver createZipArchiver(File outputFile) throws ArchiveException, IOException {
        return Archiver.createZipArchiver(outputFile, false);
    }

    public static Archiver createZipArchiver(File outputFile, boolean compress) throws ArchiveException, IOException {
        ZipArchiveOutputStream zout = new ZipArchiveOutputStream(outputFile);
        zout.setEncoding("UTF-8");
        zout.setFallbackToUTF8(true);
        zout.setUseLanguageEncodingFlag(true);
        if (compress) {
            zout.setMethod(8);
        } else {
            zout.setMethod(0);
        }
        zout.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
        return new Archiver(zout);
    }

    public static Archiver createZipArchiver(Path outputPath) throws ArchiveException, IOException {
        if (outputPath == null) {
            throw new IllegalArgumentException("outputPath can't be null");
        }
        return Archiver.createZipArchiver(outputPath.toFile());
    }

    public static Archiver createZipArchiver(Path outputPath, boolean compress) throws ArchiveException, IOException {
        if (outputPath == null) {
            throw new IllegalArgumentException("outputPath can't be null");
        }
        return Archiver.createZipArchiver(outputPath.toFile(), compress);
    }

    private Archiver(ArchiveOutputStream archiveOutputStream) throws IOException {
        super(Archiver.class);
        this.archiveOutputStream = archiveOutputStream;
        this.setVetoDelegate((ArchiveVetoDelegate)new DefaultZipVetoDelegate());
    }

    public Archiver addArchiverEventListener(ArchiverEventListener<Archiver> listener) {
        super.addArchiverEventListener(listener);
        return this;
    }

    public Archiver compress(File inputFile) throws ArchiveException, IOException {
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile can't be null");
        }
        if (this.archiveOutputStream == null) {
            throw new IllegalStateException("os can't be null");
        }
        this.fireArchiveStarted();
        new MyDirectoryWalker().walk(inputFile);
        if (this.errorCount > 0) {
            this.fireArchiveFailed();
        } else {
            this.fireArchiveCompleted();
        }
        return this;
    }

    public Archiver compress(Path inputFile) throws ArchiveException, IOException {
        if (inputFile == null) {
            throw new IllegalArgumentException("inputFile can't be null");
        }
        return this.compress(inputFile.toFile());
    }

    public Archiver removeArchiverEventListener(ArchiverEventListener<Archiver> listener) {
        super.removeArchiverEventListener(listener);
        return this;
    }

    public Archiver setStorageDelegate(ArchiveStorageProfileDelegate storageDelegate) {
        this.storageDelegate = storageDelegate;
        return this;
    }

    public Archiver setVetoDelegate(ArchiveVetoDelegate<Archiver> delegate) {
        super.setVetoDelegate(delegate);
        return this;
    }

    private class MyDirectoryWalker
    extends DirectoryWalker<File> {
        private String path;
        private int length;

        private MyDirectoryWalker() {
        }

        public void walk(File file) throws IOException, ArchiveException {
            this.walk(file, new ArrayList());
        }

        @Override
        protected void handleEnd(Collection<File> items) throws IOException {
            Archiver.this.archiveOutputStream.finish();
            Archiver.this.archiveOutputStream.close();
            super.handleEnd(items);
        }

        @Override
        protected void handleFile(File file, int depth, Collection<File> items) throws IOException {
            if (Archiver.this.shouldSkip(file)) {
                Archiver.this.fireItemSkipped(file);
            } else {
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                    String path = file.getAbsolutePath().substring(this.length);
                    ZipArchiveEntry entry = new ZipArchiveEntry(path);
                    if (Archiver.this.storageDelegate != null) {
                        int level = Archiver.this.storageDelegate.shouldCompress(file) ? 8 : 0;
                        entry.setMethod(level);
                    }
                    Archiver.this.archiveOutputStream.putArchiveEntry(entry);
                    NotifyingIOUtils.copy(input, Archiver.this.archiveOutputStream, new Progress(file));
                    IOUtils.closeQuietly(input);
                    Archiver.this.archiveOutputStream.closeArchiveEntry();
                }
                catch (FileNotFoundException oops) {
                    Archiver.this.fireItemFailed(file, oops);
                }
            }
            super.handleFile(file, depth, items);
        }

        @Override
        protected void handleStart(File file, Collection<File> items) throws IOException {
            this.path = file.getAbsolutePath();
            this.length = this.path.length() + 1;
            super.handleStart(file, items);
        }
    }

    public class DefaultArchiveStorageProfileDelegate
    implements ArchiveStorageProfileDelegate {
        private final boolean defaultMode;

        public DefaultArchiveStorageProfileDelegate(boolean mode) {
            this.defaultMode = mode;
        }

        @Override
        public boolean shouldCompress(File item) {
            return this.defaultMode;
        }
    }

    class Progress
    implements NotifyingIOUtils.IOProgressListener {
        private final File file;
        private final long length;

        Progress(File file) {
            this.file = file;
            this.length = file.length();
        }

        @Override
        public void completed() {
            Archiver.this.fireItemCompleted(this.file);
        }

        @Override
        public void failed(IOException oops) {
            Archiver.this.errorCount++;
            Archiver.this.fireItemFailed(this.file, oops);
        }

        @Override
        public void started() {
            Archiver.this.fireItemStarted(this.file);
        }

        @Override
        public void statusUpdate(long count) {
            Archiver.this.fireItemInProgress(this.file, count, this.length);
        }
    }
}

