/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.filters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaggableFilter
implements Predicate<Taggable>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TaggableFilter.class);
    private static final String KEYS_SEPARATOR = "|";
    private static final String VALUES_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "->";
    private static final String COUPLED_KEYS_SEPARATOR = "&";
    private static final String COUPLED_KEYS_GROUP = "^";
    private static final long serialVersionUID = -7554425273207469255L;
    private transient Validators validators;
    private final Class<?> childrenOf;
    private final Set<TagGroup> allowedTags;

    public TaggableFilter(String definition) {
        this(definition, Taggable.class);
    }

    public TaggableFilter(String definition, Class<?> childrenOf) {
        this.childrenOf = childrenOf;
        try {
            if (definition.isEmpty()) {
                this.allowedTags = new HashSet<TagGroup>();
            } else {
                this.allowedTags = this.setAllowedTags(definition);
                this.checkAllowedTags();
            }
        }
        catch (Throwable error) {
            throw new CoreException("Unable to setup TaggableFilter with definition {}", definition, error);
        }
    }

    public synchronized Validators getValidators() {
        if (this.validators == null) {
            this.validators = new Validators(this.childrenOf);
        }
        return this.validators;
    }

    @Override
    public boolean test(Taggable taggable) {
        if (this.allowedTags.isEmpty()) {
            return true;
        }
        for (TagGroup group : this.allowedTags) {
            if (!this.isValid(taggable, group)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.allowedTags.toString();
    }

    protected List<String> checkAllowedTags() {
        ArrayList<String> failedValidation = new ArrayList<String>();
        for (TagGroup tagGroup : this.allowedTags) {
            for (MultiMap<String, String> valuesWorkingTogether : tagGroup) {
                for (String key : valuesWorkingTogether.keySet()) {
                    if (this.getValidators().findClassDefining(key).isPresent()) {
                        Iterator iterator = valuesWorkingTogether.get(key).iterator();
                        while (iterator.hasNext()) {
                            String value = (String)iterator.next();
                            String parsedValue = value;
                            if (parsedValue.startsWith("!") && (parsedValue = parsedValue.substring(1)).isEmpty() || parsedValue.startsWith("*") || this.getValidators().isValidFor(key, parsedValue)) continue;
                            logger.warn("Unable to recognize tag value {} associated with tag key {} in {}", new Object[]{parsedValue, key, tagGroup});
                            failedValidation.add(parsedValue);
                        }
                        continue;
                    }
                    logger.warn("Unable to recognize tag key {} in {}", (Object)key, (Object)tagGroup);
                    failedValidation.add(key);
                }
            }
        }
        return failedValidation;
    }

    private boolean isValid(Taggable taggable, MultiMap<String, String> andGroup) {
        for (String key : andGroup.keySet()) {
            if (!taggable.containsValue(key, (Iterable<String>)andGroup.get(key))) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(Taggable taggable, TagGroup tagGroup) {
        for (MultiMap<String, String> andGroup : tagGroup) {
            if (this.isValid(taggable, andGroup)) continue;
            return false;
        }
        return true;
    }

    private Set<TagGroup> setAllowedTags(String definition) {
        HashSet<TagGroup> allowedTags = new HashSet<TagGroup>();
        StringList orGroups = StringList.split(definition, KEYS_SEPARATOR);
        orGroups.forEach(orGroup -> {
            TagGroup tagGroup = new TagGroup();
            StringList andGroups = StringList.split(orGroup, COUPLED_KEYS_SEPARATOR);
            andGroups.forEach(andGroup -> {
                MultiMap<String, String> tags = new MultiMap<String, String>();
                StringList carets = StringList.split(andGroup, COUPLED_KEYS_GROUP);
                carets.forEach(caret -> {
                    StringList keyValue = StringList.split(caret, KEY_VALUE_SEPARATOR);
                    String key = keyValue.get(0);
                    StringList values = StringList.split(keyValue.get(1), VALUES_SEPARATOR);
                    values.forEach(value -> tags.add(key.toLowerCase(), value.toLowerCase()));
                });
                tagGroup.addTags(tags);
            });
            allowedTags.add(tagGroup);
        });
        return allowedTags;
    }

    public static class TagGroup
    implements Iterable<MultiMap<String, String>>,
    Serializable {
        private static final long serialVersionUID = -3963233623607200077L;
        private final Set<MultiMap<String, String>> valuesWorkingTogether = new HashSet<MultiMap<String, String>>();

        public void addTags(MultiMap<String, String> tags) {
            this.valuesWorkingTogether.add(tags);
        }

        @Override
        public Iterator<MultiMap<String, String>> iterator() {
            return this.valuesWorkingTogether.iterator();
        }

        public String toString() {
            return this.valuesWorkingTogether.toString();
        }
    }
}

