/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.filters;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ConfiguredTaggableFilter
implements Predicate<Taggable>,
Serializable {
    private static final long serialVersionUID = -3849791821180104953L;
    public static final String FILTERS_CONFIGURATION_NAME = "filters";
    private final List<TaggableFilter> filters;

    public ConfiguredTaggableFilter(Configuration configuration) {
        this.filters = ((List)configuration.get(FILTERS_CONFIGURATION_NAME).valueOption().orElseThrow(() -> new CoreException("No filters defined in configuration {}", configuration))).stream().map(TaggableFilter::new).collect(Collectors.toList());
    }

    @Override
    public boolean test(Taggable taggable) {
        for (TaggableFilter filter : this.filters) {
            if (filter.test(taggable)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.filters.toString();
    }

    protected List<TaggableFilter> getFilters() {
        return this.filters;
    }
}

