/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

public class Tagger<T extends Enum<T>>
implements Serializable {
    private static final long serialVersionUID = -9170158494924659179L;
    private final Class<T> type;
    private final String tagName;
    private final Cache<String, Optional<T>> cache;

    public Tagger(Class<T> type) {
        this.type = type;
        this.tagName = Validators.findTagNameIn(type);
        this.cache = CacheBuilder.newBuilder().build();
    }

    public Optional<T> getTag(Taggable taggable) {
        Optional<String> possibleTagValue = taggable.getTag(this.tagName);
        if (possibleTagValue.isPresent()) {
            String tagValue = possibleTagValue.get();
            try {
                return this.cache.get(tagValue, () -> Validators.fromAnnotation(this.type, taggable));
            }
            catch (ExecutionException e) {
                throw new CoreException("Error getting tag value from the cache", e);
            }
        }
        return Optional.empty();
    }
}

