/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.cache.Tagger;

public class CachingValidator {
    private static CachingValidator INSTANCE = new CachingValidator();
    private final Map<Class, Tagger> map = new HashMap<Class, Tagger>();

    public static CachingValidator getInstance() {
        return INSTANCE;
    }

    public <T extends Enum<T>> Optional<T> from(Class<T> tagType, Taggable taggable) {
        Tagger<T> tagger = this.getTagger(tagType);
        return tagger.getTag(taggable);
    }

    private synchronized <T extends Enum<T>> Tagger<T> addTagger(Class<T> tagType) {
        Tagger<T> tagger = this.map.get(tagType);
        if (tagger == null) {
            tagger = new Tagger<T>(tagType);
            this.map.put(tagType, tagger);
        }
        return tagger;
    }

    private <T extends Enum<T>> Tagger<T> getTagger(Class<T> tagType) {
        Tagger<T> tagger = this.map.get(tagType);
        if (tagger == null) {
            tagger = this.addTagger(tagType);
        }
        return tagger;
    }
}

