/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import com.google.common.base.Objects;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

public class TagDocumenter {
    private final Set<CallbackData> tagData = new TreeSet<CallbackData>();

    public TagDocumenter() {
        this("org.openstreetmap.atlas");
    }

    public TagDocumenter(String packageName) {
        new FastClasspathScanner(packageName).matchClassesWithAnnotation(Tag.class, tagClass -> {
            if (!tagClass.getName().contains("TestCase")) {
                this.tagData.add(this.createCallbackDataFromClass(tagClass));
            }
        }).scan();
    }

    public void walk(Callback callback) {
        this.tagData.stream().forEach(metadata -> callback.tagFound((CallbackData)metadata));
    }

    private CallbackData createCallbackDataFromClass(Class<?> tagClass) {
        CallbackData returnValue = new CallbackData();
        Validators.TagKeySearch.findTagKeyIn(tagClass).ifPresent(results -> {
            String tagName = results.getKeyName();
            TagKey tagKey = results.getTagKey();
            returnValue.tagKey = tagName;
            returnValue.tagClassName = tagClass.getName();
            returnValue.osmWikiLink = results.getTag().osm().length() > 0 ? URI.create(results.getTag().osm()) : null;
            returnValue.tagInfoLink = results.getTag().taginfo().length() > 0 ? URI.create(results.getTag().taginfo()) : null;
            returnValue.localized = tagKey.value() == TagKey.KeyType.LOCALIZED;
            returnValue.validationType = results.getTag().value().name();
            returnValue.synthetic = results.getTag().synthetic();
        });
        return returnValue;
    }

    public static final class CallbackData
    implements Comparable<CallbackData> {
        private String tagClassName;
        private String tagKey;
        private final SortedSet<String> validTagValues = new TreeSet<String>();
        private URI tagInfoLink;
        private URI osmWikiLink;
        private String validationType;
        private boolean localized;
        private boolean synthetic;

        CallbackData() {
        }

        @Override
        public int compareTo(CallbackData other) {
            return this.tagKey.compareTo(other.tagKey);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CallbackData) {
                CallbackData other = (CallbackData)obj;
                boolean returnValue = Objects.equal(this.tagClassName, other.tagClassName);
                returnValue = returnValue && Objects.equal(this.tagKey, other.tagKey);
                returnValue = returnValue && Objects.equal(this.validTagValues, other.validTagValues);
                returnValue = returnValue && Objects.equal(this.tagInfoLink, other.tagInfoLink);
                returnValue = returnValue && Objects.equal(this.osmWikiLink, other.osmWikiLink);
                returnValue = returnValue && Objects.equal(this.validationType, other.validationType);
                returnValue = returnValue && Objects.equal(this.localized, other.localized);
                returnValue = returnValue && Objects.equal(this.synthetic, other.synthetic);
                return returnValue;
            }
            return false;
        }

        public Optional<URI> getOsmWikiLink() {
            return Optional.ofNullable(this.osmWikiLink);
        }

        public String getTagClassName() {
            return this.tagClassName;
        }

        public Optional<URI> getTagInfoLink() {
            return Optional.ofNullable(this.tagInfoLink);
        }

        public String getTagKey() {
            return this.tagKey;
        }

        public String getValidationType() {
            return this.validationType;
        }

        public Iterable<String> getValidTagValues() {
            return this.validTagValues;
        }

        public int hashCode() {
            return Objects.hashCode(this.tagKey, this.tagClassName);
        }

        public boolean isLocalized() {
            return this.localized;
        }

        public boolean isSynthetic() {
            return this.synthetic;
        }
    }

    public static interface Callback {
        public void tagFound(CallbackData var1);
    }
}

