/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.atlas.tags.annotations.validation.ExactMatchValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NumericValidator
extends ExactMatchValidator {
    private static final Logger logger = LoggerFactory.getLogger(NumericValidator.class);
    private Long minimum;
    private Long maximum;
    private final Set<Double> exclusions = new HashSet<Double>();

    public void excludeValue(long value) {
        this.exclusions.add(new Double(value));
    }

    @Override
    public final boolean isValid(String value) {
        try {
            return super.isValid(value) || this.withinRange(this.parse(value));
        }
        catch (NumberFormatException oops) {
            return false;
        }
    }

    public void setMaximum(long maximum) {
        if (this.minimum == null) {
            this.maximum = maximum;
        } else if (maximum > this.minimum) {
            this.maximum = maximum;
        } else {
            logger.debug("Cannot set maximum less than or equal to minimum {}. Consider using setRange instead.", (Object)this.minimum);
        }
    }

    public void setMinimum(long minimum) {
        if (this.maximum == null) {
            this.minimum = minimum;
        } else if (minimum < this.maximum) {
            this.minimum = minimum;
        } else {
            logger.debug("Cannot set minimum greater than or equal to maximum {}. Consider using setRange instead.", (Object)this.maximum);
        }
    }

    public void setRange(long minimum, long maximum) {
        if (minimum < maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        } else if (minimum != Long.MAX_VALUE && maximum != Long.MIN_VALUE) {
            logger.debug("Invalid range supplied, minimum: {} cannot be greater than maximum: {}.", (Object)minimum, (Object)maximum);
        }
    }

    protected boolean checkExclusions(Number checkMe) {
        return this.exclusions.contains(checkMe.doubleValue());
    }

    protected abstract Number parse(String var1);

    protected boolean withinRange(Number checkMe) {
        if (this.checkExclusions(checkMe)) {
            return false;
        }
        double theValue = checkMe.doubleValue();
        if (this.minimum != null && theValue < (double)this.minimum.longValue()) {
            return false;
        }
        return this.maximum == null || !(theValue > (double)this.maximum.longValue());
    }
}

