/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.tags.annotations.validation.TagValidator;

public class ExactMatchValidator
implements TagValidator {
    private final Set<String> values = new HashSet<String>();
    private final Set<Pattern> regexes = new HashSet<Pattern>();

    @Override
    public boolean isValid(String value) {
        if (this.values.contains(value)) {
            return true;
        }
        for (Pattern pattern : this.regexes) {
            if (!pattern.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    public ExactMatchValidator withRegularExpressions(String ... regexes) {
        this.regexes.addAll(Arrays.asList(regexes).stream().map(regex -> Pattern.compile(regex)).collect(Collectors.toSet()));
        return this;
    }

    public ExactMatchValidator withValues(String ... values) {
        this.values.addAll(Arrays.asList(values));
        return this;
    }
}

