/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.extraction.TagExtractor;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class IsoCountryExtractor
implements TagExtractor<List<IsoCountry>> {
    @Override
    public Optional<List<IsoCountry>> validateAndExtract(String value, Tag tag) {
        List countries = StringList.split(value, ",").stream().map(IsoCountry::forCountryCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Optional.of(countries);
    }
}

