/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TurnLanesBackwardTag;
import org.openstreetmap.atlas.tags.TurnLanesForwardTag;
import org.openstreetmap.atlas.tags.TurnLanesTag;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.OptionalIterable;

@Tag(value=Tag.Validation.NON_EMPTY_STRING, taginfo="http://taginfo.openstreetmap.org/keys/turn#values", osm="https://wiki.openstreetmap.org/wiki/Key:turn")
public interface TurnTag {
    @TagKey
    public static final String KEY = "turn";
    public static final String TURN_LANE_DELIMITER = "\\|";
    public static final String TURN_TYPE_DELIMITER = ";";

    public static Optional<List<Set<TurnType>>> getTurns(Taggable taggable) {
        return taggable.getTag(KEY).map(tagValue -> Arrays.stream(tagValue.split(TURN_LANE_DELIMITER)).map(lane -> Arrays.stream(lane.split(TURN_TYPE_DELIMITER)).map(TurnType::safeValueOf).filter(Objects::nonNull).collect(Collectors.toSet())).collect(Collectors.toList()));
    }

    public static boolean hasTurn(Taggable taggable, TurnType turnType) {
        OptionalIterable turnLanes = new OptionalIterable(Iterables.iterable(TurnTag.getTurns(taggable), TurnLanesTag.getTurnLanes(taggable), TurnLanesForwardTag.getForwardTurnLanes(taggable), TurnLanesBackwardTag.getBackwardTurnLanes(taggable)));
        return Iterables.asList(turnLanes).stream().anyMatch(lanes -> lanes.stream().anyMatch(turnLane -> turnLane.contains((Object)turnType)));
    }

    public static boolean hasTurn(Taggable taggable) {
        return taggable.getTag(KEY).isPresent() || taggable.getTag("turn:lanes").isPresent() || taggable.getTag("turn:lanes:forward").isPresent() || taggable.getTag("turn:lanes:backward").isPresent();
    }

    public static enum TurnType {
        LEFT,
        SHARP_LEFT,
        SLIGHT_LEFT,
        THROUGH,
        RIGHT,
        SHARP_RIGHT,
        SLIGHT_RIGHT,
        REVERSE,
        MERGE_TO_LEFT,
        MERGE_TO_RIGHT,
        NONE;

        static final EnumSet<TurnType> leftTurn;
        static final EnumSet<TurnType> rightTurn;

        static TurnType safeValueOf(String value) {
            try {
                return TurnType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }

        static {
            leftTurn = EnumSet.of(LEFT, SHARP_LEFT, SLIGHT_LEFT, MERGE_TO_LEFT);
            rightTurn = EnumSet.of(RIGHT, SHARP_RIGHT, SLIGHT_RIGHT, MERGE_TO_RIGHT);
        }
    }
}

