/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.TagValue;
import org.openstreetmap.atlas.tags.annotations.extraction.SpeedExtractor;
import org.openstreetmap.atlas.utilities.scalars.Speed;

@Tag(value=Tag.Validation.SPEED, taginfo="http://taginfo.openstreetmap.org/keys/maxspeed#values", osm="http://wiki.openstreetmap.org/wiki/Key:maxspeed")
public interface MaxSpeedBackwardTag {
    @TagKey
    public static final String KEY = "maxspeed:backward";
    @TagValue
    public static final String NONE = "none";

    public static Optional<Speed> get(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            return SpeedExtractor.validateAndExtract(tagValue.get());
        }
        return Optional.empty();
    }

    public static boolean hasMaxSpeedBackward(Taggable taggable) {
        return taggable.getTag(KEY).isPresent();
    }
}

