/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.IsoCountryExtractor;

@Tag(value=Tag.Validation.ISO2_COUNTRY)
public interface Iso31662CountryTag {
    @TagKey
    public static final String KEY = "ISO3166-1:alpha2";

    public static Iterable<IsoCountry> all(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            IsoCountryExtractor extractor = new IsoCountryExtractor();
            Optional<List<IsoCountry>> countries = extractor.validateAndExtract(tagValue.get(), Iso31662CountryTag.class.getDeclaredAnnotation(Tag.class));
            return countries.isPresent() ? (Iterable)countries.get() : new ArrayList();
        }
        return new ArrayList<IsoCountry>();
    }
}

