/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.converters;

import com.google.common.primitives.Ints;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoIntegerArray;
import org.openstreetmap.atlas.proto.ProtoIntegerArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.IntegerArrayOfArrays;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class ProtoIntegerArrayOfArraysConverter
implements TwoWayConverter<ProtoIntegerArrayOfArrays, IntegerArrayOfArrays> {
    @Override
    public ProtoIntegerArrayOfArrays backwardConvert(IntegerArrayOfArrays array) {
        if (array.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot convert {}, size too large ({})", array.getClass().getName(), array.size());
        }
        ProtoIntegerArrayOfArrays.Builder arraysBuilder = ProtoIntegerArrayOfArrays.newBuilder();
        for (int[] elementArray : array) {
            ProtoIntegerArray.Builder subArrayBuilder = ProtoIntegerArray.newBuilder();
            if (elementArray == null) {
                throw new CoreException("{} cannot convert arrays with null elements", this.getClass().getName());
            }
            for (int element : elementArray) {
                subArrayBuilder.addElements(element);
            }
            arraysBuilder.addArrays(subArrayBuilder);
        }
        if (array.getName() != null) {
            arraysBuilder.setName(array.getName());
        }
        return arraysBuilder.build();
    }

    @Override
    public IntegerArrayOfArrays convert(ProtoIntegerArrayOfArrays protoArray) {
        IntegerArrayOfArrays integerArrayOfArrays = new IntegerArrayOfArrays(protoArray.getArraysCount(), protoArray.getArraysCount(), protoArray.getArraysCount());
        protoArray.getArraysList().stream().forEach(array -> {
            int[] items = Ints.toArray(array.getElementsList());
            integerArrayOfArrays.add(items);
        });
        if (protoArray.hasName()) {
            integerArrayOfArrays.setName(protoArray.getName());
        }
        return integerArrayOfArrays;
    }
}

