/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.StringCompressedPolyLine;
import org.openstreetmap.atlas.proto.ProtoPolygonArray;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.utilities.arrays.PolygonArray;

public class ProtoPolygonArrayAdapter
implements ProtoAdapter {
    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        ProtoPolygonArray protoPolygonArray = null;
        try {
            protoPolygonArray = ProtoPolygonArray.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        int encodingsCount = protoPolygonArray.getEncodingsCount();
        PolygonArray polygonArray = new PolygonArray(encodingsCount, encodingsCount, encodingsCount);
        for (ByteString encoding : protoPolygonArray.getEncodingsList()) {
            polygonArray.add(new Polygon(new StringCompressedPolyLine(encoding.toByteArray()).asPolyLine()));
        }
        if (protoPolygonArray.hasName()) {
            polygonArray.setName(protoPolygonArray.getName());
        }
        return polygonArray;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof PolygonArray)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        PolygonArray polygonArray = (PolygonArray)serializable;
        if (polygonArray.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot serialize {}, size too large ({})", polygonArray.getClass().getName(), polygonArray.size());
        }
        ProtoPolygonArray.Builder protoPolygonArrayBuilder = ProtoPolygonArray.newBuilder();
        for (Polygon polygon : polygonArray) {
            if (polygon == null) {
                throw new CoreException("{} cannot serialize arrays with null elements", this.getClass().getName());
            }
            protoPolygonArrayBuilder.addEncodings(ByteString.copyFrom(new StringCompressedPolyLine(polygon).getEncoding()));
        }
        if (polygonArray.getName() != null) {
            protoPolygonArrayBuilder.setName(polygonArray.getName());
        }
        return protoPolygonArrayBuilder.build().toByteArray();
    }
}

