/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.InvalidProtocolBufferException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoLongArray;
import org.openstreetmap.atlas.proto.ProtoLongToLongMap;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.utilities.maps.LongToLongMap;

public class ProtoLongToLongMapAdapter
implements ProtoAdapter {
    private static final int DEFAULT_MAX_SIZE = 1024;

    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        ProtoLongToLongMap protoLongToLongMap = null;
        try {
            protoLongToLongMap = ProtoLongToLongMap.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        String deserializedName = null;
        if (protoLongToLongMap.hasName()) {
            deserializedName = protoLongToLongMap.getName();
        }
        int size = protoLongToLongMap.getKeys().getElementsCount() <= 1024 ? 1024 : protoLongToLongMap.getKeys().getElementsCount();
        LongToLongMap longToLongMap = new LongToLongMap(deserializedName, size, size, size, size, size, size);
        for (int index = 0; index < protoLongToLongMap.getKeys().getElementsCount(); ++index) {
            longToLongMap.put(protoLongToLongMap.getKeys().getElements(index), protoLongToLongMap.getValues().getElements(index));
        }
        return longToLongMap;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof LongToLongMap)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        LongToLongMap longMap = (LongToLongMap)serializable;
        if (longMap.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot serialize {}, size too large ({})", longMap.getClass().getName(), longMap.size());
        }
        ProtoLongToLongMap.Builder protoMapBuilder = ProtoLongToLongMap.newBuilder();
        ProtoLongArray.Builder keysBuilder = ProtoLongArray.newBuilder();
        ProtoLongArray.Builder valuesBuilder = ProtoLongArray.newBuilder();
        Iterable iterable = () -> longMap.iterator();
        for (Long key : iterable) {
            Long value = (Long)longMap.get(key);
            keysBuilder.addElements(key);
            valuesBuilder.addElements(value);
        }
        protoMapBuilder.setKeys(keysBuilder);
        protoMapBuilder.setValues(valuesBuilder);
        if (longMap.getName() != null) {
            protoMapBuilder.setName(longMap.getName());
        }
        return protoMapBuilder.build().toByteArray();
    }
}

