/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoLongArray;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.utilities.arrays.LongArray;

public class ProtoLongArrayAdapter
implements ProtoAdapter {
    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        ProtoLongArray protoLongArray = null;
        try {
            protoLongArray = ProtoLongArray.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        int elementCount = protoLongArray.getElementsCount();
        LongArray longArray = new LongArray(elementCount, elementCount, elementCount);
        protoLongArray.getElementsList().stream().forEach(element -> longArray.add(element));
        if (protoLongArray.hasName()) {
            longArray.setName(protoLongArray.getName());
        }
        return longArray;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof LongArray)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        LongArray longArray = (LongArray)serializable;
        if (longArray.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot serialize {}, size too large ({})", longArray.getClass().getName(), longArray.size());
        }
        ProtoLongArray.Builder protoLongArrayBuilder = ProtoLongArray.newBuilder();
        Iterator iterator = longArray.iterator();
        while (iterator.hasNext()) {
            long element = (Long)iterator.next();
            protoLongArrayBuilder.addElements(element);
        }
        if (longArray.getName() != null) {
            protoLongArrayBuilder.setName(longArray.getName());
        }
        return protoLongArrayBuilder.build().toByteArray();
    }
}

