/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoIntegerStringDictionary;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.utilities.compression.IntegerDictionary;

public class ProtoIntegerStringDictionaryAdapter
implements ProtoAdapter {
    private static final String NULL_SENTINEL_VALUE = "_+_NuLl{681FCC7E5213&E39443D7A0DE607A557|385D422B6092F_727517603F69880B5648}_||__";

    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        ProtoIntegerStringDictionary protoIntegerStringDictionary = null;
        try {
            protoIntegerStringDictionary = ProtoIntegerStringDictionary.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        IntegerDictionary dictionary = new IntegerDictionary();
        Integer currentIndex = protoIntegerStringDictionary.getCurrentIndex();
        List<Integer> indexes = protoIntegerStringDictionary.getIndexesList();
        ProtocolStringList words = protoIntegerStringDictionary.getWordsList();
        HashMap<String, Integer> wordToIndex = new HashMap<String, Integer>();
        HashMap<Integer, String> indexToWord = new HashMap<Integer, String>();
        for (int index = 0; index < words.size(); ++index) {
            String word = (String)words.get(index);
            if (word.equals(NULL_SENTINEL_VALUE)) {
                word = null;
            }
            Integer theIndex = indexes.get(index);
            wordToIndex.put(word, theIndex);
            indexToWord.put(theIndex, word);
        }
        Field wordToIndexField = null;
        Field indexToWordField = null;
        Field indexField = null;
        try {
            wordToIndexField = dictionary.getClass().getDeclaredField("wordToIndex");
            wordToIndexField.setAccessible(true);
            wordToIndexField.set(dictionary, wordToIndex);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to set field \"{}\" in {}", "wordToIndex", dictionary.getClass().getName(), exception);
        }
        try {
            indexToWordField = dictionary.getClass().getDeclaredField("indexToWord");
            indexToWordField.setAccessible(true);
            indexToWordField.set(dictionary, indexToWord);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to set field \"{}\" in {}", "indexToWord", dictionary.getClass().getName(), exception);
        }
        try {
            indexField = dictionary.getClass().getDeclaredField("index");
            indexField.setAccessible(true);
            indexField.set(dictionary, currentIndex);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to set field \"{}\" in {}", "index", dictionary.getClass().getName(), exception);
        }
        return dictionary;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof IntegerDictionary)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        IntegerDictionary integerDictionary = (IntegerDictionary)serializable;
        if (integerDictionary.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot serialize {}, size too large ({})", integerDictionary.getClass().getName(), integerDictionary.size());
        }
        ProtoIntegerStringDictionary.Builder protoDictionaryBuilder = ProtoIntegerStringDictionary.newBuilder();
        Field indexToWordField = null;
        Map indexToWord = null;
        Field indexField = null;
        Integer index = -1;
        try {
            indexToWordField = integerDictionary.getClass().getDeclaredField("indexToWord");
            indexToWordField.setAccessible(true);
            indexToWord = (Map)indexToWordField.get(integerDictionary);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to read field \"{}\" from {}", "indexToWord", integerDictionary.getClass().getName(), exception);
        }
        try {
            indexField = integerDictionary.getClass().getDeclaredField("index");
            indexField.setAccessible(true);
            index = (Integer)indexField.get(integerDictionary);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to read field \"{}\" from {}", "index", integerDictionary.getClass().getName(), exception);
        }
        try {
            for (Integer key : indexToWord.keySet()) {
                String word = (String)indexToWord.get(key);
                if (word == null) {
                    word = NULL_SENTINEL_VALUE;
                }
                protoDictionaryBuilder.addIndexes(key);
                protoDictionaryBuilder.addWords(word);
            }
        }
        catch (ClassCastException exception) {
            throw new CoreException("This adapter is incompatible with type parametrization of the owning {}. Must be java.lang.String", serializable.getClass().getName(), exception);
        }
        protoDictionaryBuilder.setCurrentIndex(index);
        return protoDictionaryBuilder.build().toByteArray();
    }
}

