/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.locale;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class IsoCountry {
    private static final String LOCALE_LANGUAGE = Locale.ENGLISH.getLanguage();
    private static final int ISO2_LENGTH = 2;
    private static final int ISO3_LENGTH = 3;
    private static Set<String> ALL_COUNTRY_CODES;
    private static final Map<String, String> ISO2_TO_DISPLAY_COUNTRY;
    private static final Map<String, String> ISO2_TO_ISO3;
    private static final Map<String, String> ISO3_TO_ISO2;
    private static final Map<String, IsoCountry> ISO_COUNTRIES;
    private final String iso2CountryCode;
    private final String iso3CountryCode;
    private final String displayCountry;

    public static Set<String> allCountryCodes() {
        return ALL_COUNTRY_CODES;
    }

    public static Optional<String> displayCountry(String countryCode) {
        if (countryCode != null) {
            String iso2;
            if (countryCode.length() == 2 && ISO2_TO_ISO3.keySet().contains(countryCode)) {
                String displayCountry = ISO2_TO_DISPLAY_COUNTRY.get(countryCode);
                return Optional.ofNullable(displayCountry);
            }
            if (countryCode.length() == 3 && ISO3_TO_ISO2.keySet().contains(countryCode) && (iso2 = ISO3_TO_ISO2.get(countryCode)) != null) {
                String displayCountry = ISO2_TO_DISPLAY_COUNTRY.get(iso2);
                return Optional.ofNullable(displayCountry);
            }
        }
        return Optional.empty();
    }

    public static Optional<IsoCountry> forCountryCode(String countryCode) {
        if (countryCode != null) {
            if (countryCode.length() == 2 && ISO2_TO_ISO3.keySet().contains(countryCode)) {
                return Optional.ofNullable(ISO_COUNTRIES.get(countryCode));
            }
            if (countryCode.length() == 3 && ISO3_TO_ISO2.keySet().contains(countryCode)) {
                return Optional.ofNullable(ISO_COUNTRIES.get(ISO3_TO_ISO2.get(countryCode)));
            }
        }
        return Optional.empty();
    }

    public static Optional<String> iso2ForIso3(String iso3) {
        String iso2 = null;
        if (iso3 != null) {
            iso2 = ISO3_TO_ISO2.get(iso3);
        }
        return Optional.ofNullable(iso2);
    }

    public static Optional<String> iso3ForIso2(String iso2) {
        String iso3 = null;
        if (iso2 != null) {
            iso3 = ISO2_TO_ISO3.get(iso2);
        }
        return Optional.ofNullable(iso3);
    }

    public static boolean isValidCountryCode(String isoCountry) {
        if (isoCountry != null) {
            if (isoCountry.length() == 2 && ISO2_TO_ISO3.keySet().contains(isoCountry)) {
                return true;
            }
            if (isoCountry.length() == 3 && ISO3_TO_ISO2.keySet().contains(isoCountry)) {
                return true;
            }
        }
        return false;
    }

    private IsoCountry(String iso2) {
        this.iso2CountryCode = iso2;
        this.iso3CountryCode = ISO2_TO_ISO3.get(this.iso2CountryCode);
        this.displayCountry = ISO2_TO_DISPLAY_COUNTRY.get(this.iso2CountryCode);
    }

    public String getCountryCode() {
        return this.iso2CountryCode;
    }

    public String getDisplayCountry() {
        return this.displayCountry;
    }

    public String getIso3CountryCode() {
        return this.iso3CountryCode;
    }

    public String toString() {
        return this.getDisplayCountry();
    }

    static {
        String[] countries = Locale.getISOCountries();
        ALL_COUNTRY_CODES = Collections.unmodifiableSet(Arrays.stream(countries).map(String::intern).collect(Collectors.toSet()));
        ISO2_TO_DISPLAY_COUNTRY = Collections.unmodifiableMap(Arrays.stream(countries).collect(Collectors.toMap(iso2 -> iso2.intern(), iso2 -> new Locale(LOCALE_LANGUAGE, (String)iso2).getDisplayCountry().intern())));
        ISO2_TO_ISO3 = Collections.unmodifiableMap(Arrays.stream(countries).collect(Collectors.toMap(iso2 -> iso2.intern(), iso2 -> new Locale(LOCALE_LANGUAGE, (String)iso2).getISO3Country().intern())));
        ISO3_TO_ISO2 = Collections.unmodifiableMap(ISO2_TO_ISO3.entrySet().stream().collect(Collectors.toMap(iso3 -> ((String)iso3.getValue()).intern(), iso3 -> ((String)iso3.getKey()).intern())));
        ISO_COUNTRIES = Collections.unmodifiableMap(Arrays.stream(countries).collect(Collectors.toMap(iso2 -> iso2.intern(), iso2 -> new IsoCountry((String)iso2))));
    }
}

