/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding.converters;

import org.openstreetmap.atlas.geography.sharding.DynamicTileSharding;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class DynamicTileShardingGeoJsonConverter
extends Command {
    public static final Command.Switch<WritableResource> GEOJSON = new Command.Switch("geojson", "The resource where to save the geojson tree for debugging", File::new, Command.Optionality.REQUIRED);
    public static final Command.Switch<Resource> INPUT = new Command.Switch("input", "The resource where to read the serialized tree", File::new, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new DynamicTileShardingGeoJsonConverter().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Resource input = (Resource)command.get(INPUT);
        WritableResource geojson = (WritableResource)command.get(GEOJSON);
        new DynamicTileSharding(input).saveAsGeoJson(geojson);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(GEOJSON, INPUT);
    }
}

