/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson;

import java.util.Collections;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.streaming.readers.GeoJsonReader;
import org.openstreetmap.atlas.streaming.readers.json.serializers.PropertiesLocated;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class ConcatenateGeoJsonCommand
extends Command {
    public static final Command.Switch<File> PATH = new Command.Switch("path", "The folder containing the geojson files to concatenate", File::new, Command.Optionality.REQUIRED);
    public static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The file to write the concatenated geojson to", File::new, Command.Optionality.REQUIRED);
    public static final Command.Switch<Mode> MODE = new Command.Switch("mode", "The mode of the input geoJSON objects (FILE or LINE)", value -> Mode.valueOf(value), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> FILE_PREFIX = new Command.Switch<String>("filePrefix", "The prefix of the input geoJSON file in LINE mode", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "part-");

    public static void main(String[] args) {
        new ConcatenateGeoJsonCommand().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        File folder = (File)command.get(PATH);
        File output = (File)command.get(OUTPUT);
        Mode mode = (Mode)((Object)command.get(MODE));
        String filePrefix = (String)command.get(FILE_PREFIX);
        List<File> files = folder.listFilesRecursively();
        Collections.sort(files);
        Iterable<PropertiesLocated> jsonItems = this.readGeoJsonItems(mode, files, filePrefix);
        GeoJsonObject result = new GeoJsonBuilder().createFeatureCollectionFromPropertiesLocated(jsonItems);
        JsonWriter writer = new JsonWriter(output);
        writer.write(result.jsonObject());
        writer.close();
        return 0;
    }

    protected Iterable<PropertiesLocated> readGeoJsonItems(Mode mode, Iterable<File> files, String filePrefix) {
        switch (mode) {
            case FILE: {
                return Iterables.stream(files).filter(file -> file.getName().endsWith(FileSuffix.GEO_JSON.toString())).flatMap(this::readGeoJsonItems);
            }
            case LINE: {
                return Iterables.stream(files).filter(file -> file.getName().startsWith(filePrefix)).flatMap(file -> file.lines()).map(line -> line.trim()).filter(line -> !line.isEmpty()).flatMap(this::readGeoJsonItems);
            }
        }
        throw new CoreException("Invalid Mode");
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(PATH, OUTPUT, MODE, FILE_PREFIX);
    }

    private Iterable<PropertiesLocated> readGeoJsonItems(Resource resource) {
        Iterable<PropertiesLocated> iterableOfPropertiesLocated = () -> new GeoJsonReader(resource);
        return iterableOfPropertiesLocated;
    }

    private Iterable<PropertiesLocated> readGeoJsonItems(String line) {
        return this.readGeoJsonItems(new StringResource(line));
    }

    public static enum Mode {
        FILE,
        LINE;

    }
}

