/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.coordinates;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.converters.GeodeticEarthCenteredEarthFixedConverter;

public class EarthCenteredEarthFixedCoordinate
implements Serializable {
    private static final long serialVersionUID = -3091871010423428109L;
    private static final GeodeticEarthCenteredEarthFixedConverter COORDINATE_CONVERTER = new GeodeticEarthCenteredEarthFixedConverter();
    private final double xValue;
    private final double yValue;
    private final double zValue;

    public EarthCenteredEarthFixedCoordinate() {
        this.xValue = 0.0;
        this.yValue = 0.0;
        this.zValue = 0.0;
    }

    public EarthCenteredEarthFixedCoordinate(double xValue, double yValue, double zValue) {
        this.xValue = xValue;
        this.yValue = yValue;
        this.zValue = zValue;
    }

    public EarthCenteredEarthFixedCoordinate(Location location) {
        EarthCenteredEarthFixedCoordinate coordinate = (EarthCenteredEarthFixedCoordinate)COORDINATE_CONVERTER.apply(location.toGeodeticCoordinate());
        this.xValue = coordinate.getX();
        this.yValue = coordinate.getY();
        this.zValue = coordinate.getZ();
    }

    public boolean equals(Object other) {
        if (other instanceof EarthCenteredEarthFixedCoordinate) {
            EarthCenteredEarthFixedCoordinate that = (EarthCenteredEarthFixedCoordinate)other;
            return this.getX() == that.getX() && this.getY() == that.getY() && this.getZ() == that.getZ();
        }
        return false;
    }

    public double getX() {
        return this.xValue;
    }

    public double getY() {
        return this.yValue;
    }

    public double getZ() {
        return this.zValue;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getX()).append(this.getY()).append(this.getZ()).hashCode();
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }
}

