/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktMultiPolygonConverter
implements TwoWayConverter<MultiPolygon, String> {
    @Override
    public MultiPolygon backwardConvert(String wkt) {
        com.vividsolutions.jts.geom.MultiPolygon geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (com.vividsolutions.jts.geom.MultiPolygon)myReader.read(wkt);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsMultiPolygonToMultiPolygonConverter().convert(geometry);
    }

    @Override
    public String convert(MultiPolygon multiPolygon) {
        com.vividsolutions.jts.geom.MultiPolygon geometry = new JtsMultiPolygonToMultiPolygonConverter().backwardConvert(multiPolygon);
        return new WKTWriter().write(geometry);
    }
}

