/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolyLine;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolyLineConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktMultiPolyLineConverter
implements TwoWayConverter<MultiPolyLine, String> {
    @Override
    public MultiPolyLine backwardConvert(String wkt) {
        MultiLineString geometry = null;
        WKTReader myReader = new WKTReader();
        try {
            geometry = (MultiLineString)myReader.read(wkt);
        }
        catch (ParseException | ClassCastException e) {
            throw new CoreException("Cannot parse wkt : {}", wkt);
        }
        return new JtsMultiPolyLineConverter().backwardConvert(geometry);
    }

    @Override
    public String convert(MultiPolyLine multiPolyLine) {
        MultiLineString geometry = new JtsMultiPolyLineConverter().convert(multiPolyLine);
        return new WKTWriter().write(geometry);
    }
}

