/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.geography.converters.WktPolyLineConverter;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class MultiplePolyLineToPolygonsConverterCommand
extends Command {
    private static final Command.Switch<File> POLYLINES = new Command.Switch("polylines", "File containing lines of semicolon separated list of WKT polylines", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> POLYGONS = new Command.Switch("polygons", "Output file that will contain lines of semicolon separated list of reconstructed polygons", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<String> DELIMITER = new Command.Switch<String>("delimiter", "The string delimiter between groups of polylines, and polygons in the output.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, ";");
    private static final WktPolyLineConverter WKT_POLY_LINE_CONVERTER = new WktPolyLineConverter();
    private static final MultiplePolyLineToPolygonsConverter MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER = new MultiplePolyLineToPolygonsConverter();

    public static void main(String[] args) {
        new MultiplePolyLineToPolygonsConverterCommand().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        String delimiter = (String)command.get(DELIMITER);
        File inputFile = (File)command.get(POLYLINES);
        StreamIterable<List> inputs = Iterables.stream(inputFile.lines()).map(line -> StringList.split(line, delimiter).stream().map(WKT_POLY_LINE_CONVERTER::backwardConvert).collect(Collectors.toList()));
        try (SafeBufferedWriter writer = this.writer(command);){
            for (List input : inputs) {
                writer.writeLine(new StringList(Iterables.stream(MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER.convert(input)).map(Polygon::toWkt)).join(delimiter));
            }
        }
        catch (Exception e) {
            throw new CoreException("Unable to convert polylines from {}", inputFile.getName(), e);
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(POLYLINES, POLYGONS, DELIMITER);
    }

    private SafeBufferedWriter writer(CommandMap command) throws FileNotFoundException {
        File output = (File)command.get(POLYGONS);
        return output != null ? output.writer() : new SafeBufferedWriter(new OutputStreamWriter(System.out));
    }
}

