/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.clipping;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.clipping.PolygonClipper;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class MultiPolygonClipper {
    private final Set<com.vividsolutions.jts.geom.Polygon> jtsClippings;

    protected MultiPolygonClipper(MultiPolygon clipping) {
        this.jtsClippings = new JtsMultiPolygonConverter().convert(clipping);
    }

    protected MultiPolygon and(MultiPolygon subject) {
        return this.runMultiPolygonClipping(subject, (sub, clipping) -> sub.intersection((Geometry)clipping));
    }

    protected MultiPolygon and(Polygon subject) {
        return this.runPolygonClipping(subject, (sub, clipping) -> sub.intersection((Geometry)clipping));
    }

    protected List<PolyLine> and(PolyLine subject) {
        return this.runPolyLineClipping(subject, (sub, clipping) -> sub.intersection((Geometry)clipping));
    }

    protected MultiPolygon not(MultiPolygon subject) {
        return this.runMultiPolygonClipping(subject, (sub, clipping) -> sub.difference((Geometry)clipping));
    }

    protected MultiPolygon not(Polygon subject) {
        return this.runPolygonClipping(subject, (sub, clipping) -> sub.difference((Geometry)clipping));
    }

    protected List<PolyLine> not(PolyLine subject) {
        return this.runPolyLineClipping(subject, (sub, clipping) -> sub.difference((Geometry)clipping));
    }

    protected MultiPolygon union(MultiPolygon subject) {
        return this.runMultiPolygonClipping(subject, (sub, clipping) -> sub.union((Geometry)clipping));
    }

    protected MultiPolygon union(Polygon subject) {
        return this.runPolygonClipping(subject, (sub, clipping) -> sub.union((Geometry)clipping));
    }

    protected List<PolyLine> union(PolyLine subject) {
        return this.runPolyLineClipping(subject, (sub, clipping) -> sub.union((Geometry)clipping));
    }

    protected MultiPolygon xor(MultiPolygon subject) {
        return this.runMultiPolygonClipping(subject, (sub, clipping) -> sub.symDifference((Geometry)clipping));
    }

    protected MultiPolygon xor(Polygon subject) {
        return this.runPolygonClipping(subject, (sub, clipping) -> sub.symDifference((Geometry)clipping));
    }

    protected List<PolyLine> xor(PolyLine subject) {
        return this.runPolyLineClipping(subject, (sub, clipping) -> sub.symDifference((Geometry)clipping));
    }

    private MultiPolygon processMultiPolygon(Geometry intersections) {
        MultiPolygon result = new MultiPolygon(new MultiMap<Polygon, Polygon>());
        if (intersections instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)intersections;
            int numGeometries = collection.getNumGeometries();
            for (int n = 0; n < numGeometries; ++n) {
                Geometry geometry = collection.getGeometryN(n);
                result = result.merge(this.processMultiPolygon(geometry));
            }
        } else if (intersections instanceof com.vividsolutions.jts.geom.Polygon) {
            HashSet<com.vividsolutions.jts.geom.Polygon> set = new HashSet<com.vividsolutions.jts.geom.Polygon>();
            set.add((com.vividsolutions.jts.geom.Polygon)intersections);
            result = result.merge(new JtsMultiPolygonConverter().backwardConvert((Set<com.vividsolutions.jts.geom.Polygon>)set));
        }
        return result;
    }

    private List<PolyLine> processPolyLine(Geometry intersections) {
        ArrayList<PolyLine> result = new ArrayList<PolyLine>();
        if (intersections instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)intersections;
            int numGeometries = collection.getNumGeometries();
            for (int n = 0; n < numGeometries; ++n) {
                Geometry geometry = collection.getGeometryN(n);
                result.addAll(this.processPolyLine(geometry));
            }
        } else if (intersections instanceof LineString) {
            result.add(new JtsPolyLineConverter().backwardConvert((LineString)intersections));
        }
        return result;
    }

    private MultiPolygon runMultiPolygonClipping(MultiPolygon subject, BiFunction<Geometry, Geometry, Geometry> application) {
        MultiPolygon result = new MultiPolygon(new MultiMap<Polygon, Polygon>());
        Set<com.vividsolutions.jts.geom.Polygon> jtsSubjects = new JtsMultiPolygonConverter().convert(subject);
        for (com.vividsolutions.jts.geom.Polygon jtsClipping : this.jtsClippings) {
            for (com.vividsolutions.jts.geom.Polygon jtsSubject : jtsSubjects) {
                result = result.merge(this.processMultiPolygon(application.apply(jtsSubject, jtsClipping)));
            }
        }
        return result;
    }

    private MultiPolygon runPolygonClipping(Polygon subject, BiFunction<Geometry, Geometry, Geometry> application) {
        MultiPolygon result = new MultiPolygon(new MultiMap<Polygon, Polygon>());
        for (com.vividsolutions.jts.geom.Polygon jtsClipping : this.jtsClippings) {
            result = result.merge(this.processMultiPolygon(application.apply(PolygonClipper.getJts(subject), jtsClipping)));
        }
        return result;
    }

    private List<PolyLine> runPolyLineClipping(PolyLine subject, BiFunction<Geometry, Geometry, Geometry> application) {
        ArrayList<PolyLine> result = new ArrayList<PolyLine>();
        for (com.vividsolutions.jts.geom.Polygon jtsClipping : this.jtsClippings) {
            result.addAll(this.processPolyLine(application.apply(PolygonClipper.getJts(subject), jtsClipping)));
        }
        return result;
    }
}

